/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.security;

import com.veraxsystems.vxipmi.coding.security.AuthenticationAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthenticationRakpHmacSha1
extends AuthenticationAlgorithm {
    private Mac mac = Mac.getInstance("HmacSHA1");

    @Override
    public byte getCode() {
        return 1;
    }

    @Override
    public boolean checkKeyExchangeAuthenticationCode(byte[] data, byte[] key, String password) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] check = this.getKeyExchangeAuthenticationCode(data, password);
        return Arrays.equals(check, key);
    }

    @Override
    public byte[] getKeyExchangeAuthenticationCode(byte[] data, String password) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] key = password.getBytes();
        SecretKeySpec sKey = new SecretKeySpec(key, "HmacSHA1");
        this.mac.init(sKey);
        return this.mac.doFinal(data);
    }

    @Override
    public boolean doIntegrityCheck(byte[] data, byte[] reference, byte[] sik) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec sKey = new SecretKeySpec(sik, "HmacSHA1");
        this.mac.init(sKey);
        byte[] result = new byte[this.getIntegrityCheckBaseLength()];
        System.arraycopy(this.mac.doFinal(data), 0, result, 0, this.getIntegrityCheckBaseLength());
        return Arrays.equals(result, reference);
    }

    @Override
    public int getKeyLength() {
        return 20;
    }

    @Override
    public int getIntegrityCheckBaseLength() {
        return 12;
    }
}

