/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.security;

import com.veraxsystems.vxipmi.coding.security.ConfidentialityAlgorithm;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ConfidentialityAesCbc128
extends ConfidentialityAlgorithm {
    private static final byte[] CONST2 = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private Cipher cipher;
    private SecretKeySpec cipherKey;

    @Override
    public byte getCode() {
        return 1;
    }

    @Override
    public void initialize(byte[] sik) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        super.initialize(sik);
        SecretKeySpec k2 = new SecretKeySpec(sik, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(k2);
        byte[] ckey = mac.doFinal(CONST2);
        byte[] ciphKey = new byte[16];
        System.arraycopy(ckey, 0, ciphKey, 0, 16);
        this.cipherKey = new SecretKeySpec(ciphKey, "AES");
        this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
    }

    @Override
    public byte[] encrypt(byte[] data) throws InvalidKeyException {
        int length = data.length + 17;
        int pad = 0;
        if (length % 16 != 0) {
            pad = 16 - length % 16;
        }
        byte[] result = new byte[(length += pad) - 16];
        this.cipher.init(1, this.cipherKey);
        System.arraycopy(data, 0, result, 0, data.length);
        for (int i = 0; i < pad; ++i) {
            result[i + data.length] = TypeConverter.intToByte(i + 1);
        }
        result[length - 17] = TypeConverter.intToByte(pad);
        try {
            byte[] encrypted = this.cipher.doFinal(result);
            result = new byte[encrypted.length + 16];
            System.arraycopy(encrypted, 0, result, 16, encrypted.length);
            System.arraycopy(this.cipher.getIV(), 0, result, 0, 16);
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) throws IllegalArgumentException {
        byte[] decrypted = null;
        try {
            byte[] iv = new byte[16];
            System.arraycopy(data, 0, iv, 0, 16);
            byte[] encrypted = new byte[data.length - 16];
            System.arraycopy(data, 16, encrypted, 0, encrypted.length);
            this.cipher.init(2, (Key)this.cipherKey, new IvParameterSpec(iv));
            decrypted = this.cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Decryption failed", e);
        }
        int pad = TypeConverter.byteToInt(decrypted[decrypted.length - 1]);
        byte[] result = new byte[decrypted.length - pad - 1];
        System.arraycopy(decrypted, 0, result, 0, result.length);
        return result;
    }

    @Override
    public int getConfidentialityOverheadSize(int payloadSize) {
        int size = 17;
        if ((size + payloadSize) % 16 != 0) {
            size += 16 - (size + payloadSize) % 16;
        }
        return size;
    }
}

