/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.security;

import com.veraxsystems.vxipmi.coding.security.IntegrityAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class IntegrityHmacSha1_96
extends IntegrityAlgorithm {
    private Mac mac = Mac.getInstance("HmacSHA1");
    private static final byte[] CONST1 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    @Override
    public void initialize(byte[] sik) throws InvalidKeyException {
        super.initialize(sik);
        SecretKeySpec k1 = new SecretKeySpec(sik, "HmacSHA1");
        this.mac.init(k1);
        k1 = new SecretKeySpec(this.mac.doFinal(CONST1), "HmacSHA1");
        this.mac.init(k1);
    }

    @Override
    public byte getCode() {
        return 1;
    }

    @Override
    public byte[] generateAuthCode(byte[] base) {
        if (this.sik == null) {
            throw new NullPointerException("Algorithm not initialized.");
        }
        byte[] result = new byte[12];
        if (base[base.length - 2] == 0) {
            base = this.injectIntegrityPad(base, 12);
        }
        System.arraycopy(this.mac.doFinal(base), 0, result, 0, 12);
        return result;
    }
}

