/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesManager {
    private static final Logger logger = Logger.getLogger(PropertiesManager.class);
    private final Map<String, String> properties = new HashMap<String, String>();

    private PropertiesManager() {
        this.loadProperties("/connection.properties");
        this.loadProperties("/vxipmi.properties");
    }

    public static PropertiesManager getInstance() {
        return PropertiesManagerHolder.instance;
    }

    private void loadProperties(String name) {
        try {
            Properties loadedProperties = new Properties();
            loadedProperties.load(this.getClass().getResourceAsStream(name));
            for (Object key : loadedProperties.keySet()) {
                this.properties.put(key.toString(), loadedProperties.getProperty(key.toString()));
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getProperty(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting " + key + ": " + this.properties.get(key)));
        }
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    private static class PropertiesManagerHolder {
        private static final PropertiesManager instance = new PropertiesManager();

        private PropertiesManagerHolder() {
        }
    }
}

