/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.common;

import java.nio.charset.Charset;
import java.util.Date;

public final class TypeConverter {
    private TypeConverter() {
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = TypeConverter.intToByte(value >>> offset & 0xFF);
        }
        return b;
    }

    public static byte[] intToLittleEndianByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            int offset = i * 8;
            b[i] = TypeConverter.intToByte(value >>> offset & 0xFF);
        }
        return b;
    }

    public static int littleEndianByteArrayToInt(byte[] value) throws IndexOutOfBoundsException {
        if (value.length != 4) {
            throw new IndexOutOfBoundsException("Value's length must be 4.");
        }
        int result = 0;
        for (int i = 3; i >= 0; --i) {
            int offset = 8 * i;
            result |= TypeConverter.byteToInt(value[i]) << offset;
        }
        return result;
    }

    public static byte intToByte(int value) throws IllegalArgumentException {
        if (value > 255 || value < 0) {
            throw new IllegalArgumentException("Value must be in range 0-255.");
        }
        return value < 128 ? (byte)value : (byte)(value - 256);
    }

    public static int byteToInt(byte value) {
        return value >= 0 ? value : value + 256;
    }

    public static int littleEndianBcdByteToInt(byte value) {
        int lower = (TypeConverter.byteToInt(value) & 0xF0) >> 4;
        int higher = TypeConverter.byteToInt(value) & 0xF;
        return higher * 10 + lower;
    }

    public static int decode2sComplement(int value, int msb) {
        int result = value;
        boolean base = false;
        if ((value & 1 << msb) != 0) {
            base = true;
        }
        for (int i = 31; i > msb; --i) {
            int mask = 1 << i;
            if (!base) {
                result &= ~mask;
                continue;
            }
            result |= mask;
        }
        return result;
    }

    public static int decode1sComplement(int value, int msb) {
        int result = value;
        boolean base = false;
        if ((value & 1 << msb) != 0) {
            base = true;
        }
        if (base) {
            for (int i = 31; i > msb; --i) {
                int mask = 1 << i;
                result |= mask;
            }
            result = -(~result);
        }
        return result;
    }

    public static String decodeBcdPlus(byte[] text) {
        char[] result = new char[text.length * 2];
        for (int i = 0; i < text.length; ++i) {
            result[2 * i] = TypeConverter.decodeBcdPlusChar(TypeConverter.intToByte((TypeConverter.byteToInt(text[i]) & 0xF0) >> 4));
            result[2 * i + 1] = TypeConverter.decodeBcdPlusChar(TypeConverter.intToByte(TypeConverter.byteToInt(text[i]) & 0xF));
        }
        return new String(result);
    }

    private static char decodeBcdPlusChar(byte ch) {
        switch (TypeConverter.byteToInt(ch)) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return ' ';
            }
            case 11: {
                return '-';
            }
            case 12: {
                return '.';
            }
            case 13: {
                return ':';
            }
            case 14: {
                return ',';
            }
            case 15: {
                return '_';
            }
        }
        throw new IllegalArgumentException("Invalid ch value");
    }

    public static String decode6bitAscii(byte[] text) {
        int i;
        int cnt = text.length;
        if (cnt % 3 != 0) {
            cnt += 3 - cnt % 3;
        }
        byte[] newText = new byte[cnt / 3 * 4];
        int index = 0;
        block5: for (i = 0; i < text.length; ++i) {
            switch (i % 3) {
                case 0: {
                    newText[index++] = TypeConverter.intToByte(TypeConverter.byteToInt(text[i]) & 0x3F);
                    newText[index] = TypeConverter.intToByte((TypeConverter.byteToInt(text[i]) & 0xC0) >> 6);
                    continue block5;
                }
                case 1: {
                    int n = index++;
                    newText[n] = (byte)(newText[n] | TypeConverter.intToByte((TypeConverter.byteToInt(text[i]) & 0xF) << 2));
                    newText[index] = TypeConverter.intToByte((TypeConverter.byteToInt(text[i]) & 0xF0) >> 4);
                    continue block5;
                }
                case 2: {
                    int n = index++;
                    newText[n] = (byte)(newText[n] | TypeConverter.intToByte((TypeConverter.byteToInt(text[i]) & 3) << 4));
                    newText[index++] = TypeConverter.intToByte((TypeConverter.byteToInt(text[i]) & 0xFC) >> 2);
                }
            }
        }
        for (i = 0; i < newText.length; ++i) {
            newText[i] = TypeConverter.intToByte(TypeConverter.byteToInt(newText[i]) + 32);
        }
        return new String(newText, Charset.forName("US-ASCII"));
    }

    public static Date decodeDate(int date) {
        return new Date((long)date * 1000L);
    }
}

