/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilities;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelCipherSuitesResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.OpenSessionResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp1ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.Rakp3ResponseData;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.common.TypeConverter;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.ConnectionListener;
import com.veraxsystems.vxipmi.connection.ConnectionManager;
import com.veraxsystems.vxipmi.connection.StateConnectionException;
import com.veraxsystems.vxipmi.connection.queue.MessageQueue;
import com.veraxsystems.vxipmi.sm.MachineObserver;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.actions.ErrorAction;
import com.veraxsystems.vxipmi.sm.actions.GetSikAction;
import com.veraxsystems.vxipmi.sm.actions.MessageAction;
import com.veraxsystems.vxipmi.sm.actions.ResponseAction;
import com.veraxsystems.vxipmi.sm.actions.StateMachineAction;
import com.veraxsystems.vxipmi.sm.events.AuthenticationCapabilitiesReceived;
import com.veraxsystems.vxipmi.sm.events.Authorize;
import com.veraxsystems.vxipmi.sm.events.CloseSession;
import com.veraxsystems.vxipmi.sm.events.Default;
import com.veraxsystems.vxipmi.sm.events.DefaultAck;
import com.veraxsystems.vxipmi.sm.events.GetChannelCipherSuitesPending;
import com.veraxsystems.vxipmi.sm.events.OpenSessionAck;
import com.veraxsystems.vxipmi.sm.events.Rakp2Ack;
import com.veraxsystems.vxipmi.sm.events.Sendv20Message;
import com.veraxsystems.vxipmi.sm.events.StartSession;
import com.veraxsystems.vxipmi.sm.events.Timeout;
import com.veraxsystems.vxipmi.sm.states.Authcap;
import com.veraxsystems.vxipmi.sm.states.Ciphers;
import com.veraxsystems.vxipmi.sm.states.SessionValid;
import com.veraxsystems.vxipmi.sm.states.Uninitialized;
import com.veraxsystems.vxipmi.transport.Messenger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class Connection
extends TimerTask
implements MachineObserver {
    private static final Timer timer = new Timer("IPMIConnectionTimer", true);
    private static final Logger logger = Logger.getLogger(Connection.class);
    private final List<ConnectionListener> listeners = new ArrayList<ConnectionListener>();
    private final StateMachine stateMachine;
    private int timeout = -1;
    private StateMachineAction lastAction;
    private int sessionId;
    private int managedSystemSessionId;
    private byte[] sik;
    private final int handle;
    private int lastReceivedSequenceNumber = 0;
    private MessageQueue messageQueue;

    public Connection(Messenger messenger, int handle) throws FileNotFoundException, IOException {
        this.stateMachine = new StateMachine(messenger);
        this.handle = handle;
        this.timeout = Integer.parseInt(PropertiesManager.getInstance().getProperty("timeout"));
    }

    public int getHandle() {
        return this.handle;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.messageQueue.setTimeout(timeout);
    }

    public void registerListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void connect(InetAddress address, int pingPeriod) throws FileNotFoundException, IOException {
        this.messageQueue = new MessageQueue(this, this.timeout);
        timer.schedule((TimerTask)this, pingPeriod, (long)pingPeriod);
        this.stateMachine.register(this);
        this.stateMachine.start(address);
    }

    public void disconnect() {
        this.cancel();
        this.stateMachine.stop();
        this.messageQueue.tearDown();
    }

    public boolean isActive() {
        return this.stateMachine.isActive();
    }

    public List<CipherSuite> getAvailableCipherSuites(int tag) throws Exception {
        if (this.stateMachine.getCurrent().getClass() != Uninitialized.class) {
            throw new StateConnectionException(this.stateMachine.getCurrent());
        }
        boolean process = true;
        ArrayList<byte[]> rawCipherSuites = new ArrayList<byte[]>();
        while (process) {
            this.lastAction = null;
            this.stateMachine.doTransition(new GetChannelCipherSuitesPending(tag));
            this.waitForResponse();
            ResponseAction action = (ResponseAction)this.lastAction;
            if (!(action.getIpmiResponseData() instanceof GetChannelCipherSuitesResponseData)) {
                this.stateMachine.doTransition(new Timeout());
                throw new ConnectionException("Response data not matching Get Channel Cipher Suites command.");
            }
            GetChannelCipherSuitesResponseData responseData = (GetChannelCipherSuitesResponseData)action.getIpmiResponseData();
            rawCipherSuites.add(responseData.getCipherSuiteData());
            if (responseData.getCipherSuiteData().length >= 16) continue;
            process = false;
        }
        this.stateMachine.doTransition(new DefaultAck());
        int length = 0;
        for (byte[] partial : rawCipherSuites) {
            length += partial.length;
        }
        byte[] csRaw = new byte[length];
        int index = 0;
        for (byte[] partial : rawCipherSuites) {
            System.arraycopy(partial, 0, csRaw, index, partial.length);
            index += partial.length;
        }
        return CipherSuite.getCipherSuites(csRaw);
    }

    public List<CipherSuite> getAllCipherSuites(int tag) throws StateConnectionException {
        if (this.stateMachine.getCurrent().getClass() != Uninitialized.class) {
            throw new StateConnectionException(this.stateMachine.getCurrent());
        }
        this.stateMachine.doTransition(new GetChannelCipherSuitesPending(tag));
        this.stateMachine.doTransition(new DefaultAck());
        CipherSuite[] allCs = new CipherSuite[]{new CipherSuite(0, 0, 0, 0), new CipherSuite(1, 1, 0, 0), new CipherSuite(2, 1, 1, 0), new CipherSuite(3, 1, 1, 1), new CipherSuite(4, 1, 1, 2)};
        return Arrays.asList(allCs);
    }

    private void waitForResponse() throws Exception {
        for (int time = 0; time < this.timeout && this.lastAction == null; ++time) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                break;
            }
        }
        if (this.lastAction == null) {
            this.stateMachine.doTransition(new Timeout());
            throw new IOException("Command timed out");
        }
        if (!(this.lastAction instanceof ResponseAction) && !(this.lastAction instanceof GetSikAction)) {
            if (this.lastAction instanceof ErrorAction) {
                throw ((ErrorAction)this.lastAction).getException();
            }
            throw new ConnectionException("Invalid StateMachine response: " + this.lastAction.getClass().getSimpleName());
        }
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(int tag, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        if (this.stateMachine.getCurrent().getClass() != Ciphers.class) {
            this.stateMachine.setCurrent(new Ciphers());
            throw new StateConnectionException(this.stateMachine.getCurrent());
        }
        this.lastAction = null;
        this.stateMachine.doTransition(new Default(cipherSuite, tag, requestedPrivilegeLevel));
        this.waitForResponse();
        ResponseAction action = (ResponseAction)this.lastAction;
        if (!(action.getIpmiResponseData() instanceof GetChannelAuthenticationCapabilitiesResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching Get Channel Authentication Capabilities command.");
        }
        GetChannelAuthenticationCapabilitiesResponseData responseData = (GetChannelAuthenticationCapabilitiesResponseData)action.getIpmiResponseData();
        this.sessionId = ConnectionManager.generateSessionId();
        this.stateMachine.doTransition(new AuthenticationCapabilitiesReceived(this.sessionId, requestedPrivilegeLevel));
        return responseData;
    }

    public void startSession(int tag, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey) throws Exception {
        if (this.stateMachine.getCurrent().getClass() != Authcap.class) {
            throw new StateConnectionException(this.stateMachine.getCurrent());
        }
        this.lastAction = null;
        this.stateMachine.doTransition(new Authorize(cipherSuite, tag, privilegeLevel, this.sessionId));
        this.waitForResponse();
        ResponseAction action = (ResponseAction)this.lastAction;
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof OpenSessionResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching OpenSession response data");
        }
        this.managedSystemSessionId = ((OpenSessionResponseData)action.getIpmiResponseData()).getManagedSystemSessionId();
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new OpenSessionAck(cipherSuite, privilegeLevel, tag, this.managedSystemSessionId, username, password, bmcKey));
        this.waitForResponse();
        action = (ResponseAction)this.lastAction;
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof Rakp1ResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching RAKP Message 2: " + action.getIpmiResponseData().getClass().getSimpleName());
        }
        Rakp1ResponseData rakp1ResponseData = (Rakp1ResponseData)action.getIpmiResponseData();
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new Rakp2Ack(cipherSuite, tag, 0, this.managedSystemSessionId, rakp1ResponseData));
        this.waitForResponse();
        action = (ResponseAction)this.lastAction;
        if (this.sik == null) {
            throw new ConnectionException("Session Integrity Key is null");
        }
        cipherSuite.initializeAlgorithms(this.sik);
        this.lastAction = null;
        if (!(action.getIpmiResponseData() instanceof Rakp3ResponseData)) {
            this.stateMachine.doTransition(new Timeout());
            throw new ConnectionException("Response data not matching RAKP Message 4");
        }
        this.stateMachine.doTransition(new DefaultAck());
        this.stateMachine.doTransition(new StartSession(cipherSuite, this.sessionId));
    }

    public void closeSession() throws ConnectionException {
        if (this.stateMachine.getCurrent().getClass() != SessionValid.class) {
            throw new StateConnectionException(this.stateMachine.getCurrent());
        }
        this.stateMachine.doTransition(new CloseSession(this.managedSystemSessionId, this.messageQueue.getSequenceNumber()));
    }

    public int sendIpmiCommand(IpmiCommandCoder commandCoder) throws ConnectionException, ArithmeticException {
        if (this.stateMachine.getCurrent().getClass() != SessionValid.class) {
            throw new StateConnectionException(this.stateMachine.getCurrent());
        }
        int seq = this.messageQueue.add(commandCoder);
        if (seq > 0) {
            this.stateMachine.doTransition(new Sendv20Message(commandCoder, this.managedSystemSessionId, seq));
        }
        return seq % 64;
    }

    @Deprecated
    public int retry(int tag, int maxAllowedRetries) throws ArithmeticException, ConnectionException {
        int retries = this.messageQueue.getMessageRetries(tag);
        if (retries < 0 || retries >= maxAllowedRetries) {
            return -1;
        }
        IpmiCommandCoder coder = this.messageQueue.getMessageFromQueue(tag);
        if (coder == null) {
            return -1;
        }
        this.messageQueue.remove(tag);
        return this.sendIpmiCommand(coder);
    }

    private void handleIncomingMessage(Ipmiv20Message message) throws NullPointerException {
        int seq = message.getSessionSequenceNumber();
        if (seq != 0 && (seq > this.lastReceivedSequenceNumber + 15 || seq < this.lastReceivedSequenceNumber - 16)) {
            logger.debug((Object)("Dropping message " + seq));
            return;
        }
        if (seq != 0) {
            int n = this.lastReceivedSequenceNumber = seq > this.lastReceivedSequenceNumber ? seq : this.lastReceivedSequenceNumber;
        }
        if (message.getPayload() instanceof IpmiLanResponse) {
            IpmiCommandCoder coder = this.messageQueue.getMessageFromQueue(((IpmiLanResponse)message.getPayload()).getSequenceNumber());
            byte tag = ((IpmiLanResponse)message.getPayload()).getSequenceNumber();
            logger.debug((Object)("Received message with tag " + tag));
            if (coder == null) {
                logger.debug((Object)("No message tagged with " + tag + " in queue. Dropping orphan message."));
                return;
            }
            if (coder.getClass() == GetChannelAuthenticationCapabilities.class) {
                this.messageQueue.remove(tag);
            } else {
                try {
                    ResponseData responseData = coder.getResponseData(message);
                    this.notifyListeners(this.handle, tag, responseData, null);
                }
                catch (Exception e) {
                    this.notifyListeners(this.handle, tag, null, e);
                }
                this.messageQueue.remove(((IpmiLanResponse)message.getPayload()).getSequenceNumber());
            }
        }
    }

    public void notifyListeners(int handle, int tag, ResponseData responseData, Exception exception) {
        for (ConnectionListener listener : this.listeners) {
            if (listener == null) continue;
            listener.notify(responseData, handle, tag, exception);
        }
    }

    @Override
    public void notify(StateMachineAction action) {
        if (action instanceof GetSikAction) {
            this.sik = ((GetSikAction)action).getSik();
        } else if (!(action instanceof MessageAction)) {
            this.lastAction = action;
            if (action instanceof ErrorAction) {
                ErrorAction errorAction = (ErrorAction)action;
                logger.error((Object)errorAction.getException().getMessage(), (Throwable)errorAction.getException());
            }
        } else {
            this.handleIncomingMessage(((MessageAction)action).getIpmiv20Message());
        }
    }

    @Override
    public void run() {
        int result = -1;
        do {
            try {
                if (!(this.stateMachine.getCurrent() instanceof SessionValid)) break;
                result = this.sendIpmiCommand(new GetChannelAuthenticationCapabilities(IpmiVersion.V20, IpmiVersion.V20, ((SessionValid)this.stateMachine.getCurrent()).getCipherSuite(), PrivilegeLevel.Callback, TypeConverter.intToByte(14)));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } while (result <= 0);
    }

    public InetAddress getRemoteMachineAddress() {
        return this.stateMachine.getRemoteMachineAddress();
    }

    public boolean isSessionValid() {
        return this.stateMachine.getCurrent() instanceof SessionValid;
    }
}

