/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionListener;
import com.veraxsystems.vxipmi.connection.StateConnectionException;
import com.veraxsystems.vxipmi.transport.Messenger;
import com.veraxsystems.vxipmi.transport.UdpMessenger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class ConnectionManager {
    private Messenger messenger;
    private List<Connection> connections;
    private static Integer sessionId = 100;
    private static Integer sessionlessTag = 0;
    private static List<Integer> reservedTags = new ArrayList<Integer>();
    private static int pingPeriod = -1;

    public ConnectionManager(int port) throws IOException {
        this.messenger = new UdpMessenger(port);
        this.initialize();
    }

    public ConnectionManager(int port, InetAddress address) throws IOException {
        this.messenger = new UdpMessenger(port, address);
        this.initialize();
    }

    public ConnectionManager(Messenger messenger) throws IOException {
        this.messenger = messenger;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.connections = new ArrayList<Connection>();
        reservedTags = new ArrayList<Integer>();
        if (pingPeriod == -1) {
            pingPeriod = Integer.parseInt(PropertiesManager.getInstance().getProperty("pingPeriod"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                if (connection == null || !connection.isActive()) continue;
                connection.disconnect();
            }
        }
        this.messenger.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int generateSessionId() {
        Integer n = sessionId;
        synchronized (n) {
            Integer n2 = sessionId = Integer.valueOf(sessionId % 0x1FFFFFFF);
            Integer n3 = sessionId = Integer.valueOf(sessionId + 1);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int generateSessionlessTag() {
        Integer n = sessionlessTag;
        synchronized (n) {
            List<Integer> list;
            boolean wait = true;
            while (wait) {
                sessionlessTag = sessionlessTag + 1;
                sessionlessTag = sessionlessTag % 60;
                list = reservedTags;
                synchronized (list) {
                    if (!reservedTags.contains(sessionlessTag)) {
                        wait = false;
                    }
                }
                if (!wait) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            list = reservedTags;
            synchronized (list) {
                reservedTags.add(sessionlessTag);
            }
            return sessionlessTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTag(int tag) {
        List<Integer> list = reservedTags;
        synchronized (list) {
            reservedTags.remove((Object)tag);
        }
    }

    public Connection getConnection(int index) {
        return this.connections.get(index);
    }

    public void closeConnection(int index) {
        this.connections.get(index).disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(InetAddress address) {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                if (connection == null || !connection.isActive() || connection.getRemoteMachineAddress() != address) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createConnection(InetAddress address, int pingPeriod) throws FileNotFoundException, IOException {
        Connection connection = new Connection(this.messenger, 0);
        connection.connect(address, pingPeriod);
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
            return this.connections.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createConnection(InetAddress address) throws FileNotFoundException, IOException {
        List<Connection> list = this.connections;
        synchronized (list) {
            Connection connection = new Connection(this.messenger, this.connections.size());
            connection.connect(address, pingPeriod);
            this.connections.add(connection);
            return this.connections.size() - 1;
        }
    }

    public List<CipherSuite> getAvailableCipherSuites(int connection) throws Exception {
        List<CipherSuite> suites;
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            suites = this.connections.get(connection).getAvailableCipherSuites(tag);
        }
        catch (Exception e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
        return suites;
    }

    public List<CipherSuite> getAllCipherSuites(int connection) throws StateConnectionException {
        List<CipherSuite> suites;
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            suites = this.connections.get(connection).getAllCipherSuites(tag);
        }
        catch (StateConnectionException e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
        return suites;
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(int connection, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        GetChannelAuthenticationCapabilitiesResponseData responseData;
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            responseData = this.connections.get(connection).getChannelAuthenticationCapabilities(tag, cipherSuite, requestedPrivilegeLevel);
        }
        catch (Exception e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
        return responseData;
    }

    public void startSession(int connection, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey) throws Exception {
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            this.connections.get(connection).startSession(tag, cipherSuite, privilegeLevel, username, password, bmcKey);
        }
        catch (Exception e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
    }

    public void registerListener(int connection, ConnectionListener listener) {
        this.connections.get(connection).registerListener(listener);
    }
}

