/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection.queue;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.queue.QueueElement;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class MessageQueue
extends TimerTask {
    private static final Timer timer = new Timer("IPMIMessageQueueTimer", true);
    private static final Logger logger = Logger.getLogger(MessageQueue.class);
    private final List<QueueElement> queue = new ArrayList<QueueElement>();
    private int timeout;
    private final Connection connection;
    private int lastSequenceNumber = 0;
    private final Object lastSequenceNumberLock = new Object();
    private final List<Integer> reservedTags = new ArrayList<Integer>();
    private static final int QUEUE_SIZE = 8;

    public MessageQueue(Connection connection, int timeout) throws FileNotFoundException, IOException {
        this.connection = connection;
        this.setTimeout(timeout);
        int cleaningFrequency = Integer.parseInt(PropertiesManager.getInstance().getProperty("cleaningFrequency"));
        timer.schedule((TimerTask)this, cleaningFrequency, (long)cleaningFrequency);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void tearDown() {
        this.cancel();
    }

    private synchronized boolean isReserved(int tag) {
        return this.reservedTags.contains(tag);
    }

    private synchronized boolean reserveTag(int tag) {
        if (this.isReserved(tag)) {
            this.reservedTags.add(tag);
            return true;
        }
        return false;
    }

    private synchronized void releaseTag(int tag) {
        this.reservedTags.remove((Object)tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(IpmiCommandCoder request) {
        this.run();
        boolean first = true;
        List<QueueElement> list = this.queue;
        synchronized (list) {
            Object object = this.lastSequenceNumberLock;
            synchronized (object) {
                if (this.queue.size() < 8) {
                    int sequenceNumber = (this.lastSequenceNumber + 1) % 0x1FFFFFFF;
                    if (sequenceNumber == 0) {
                        throw new ArithmeticException("Session sequence number overload. Reset session");
                    }
                    while (this.isReserved(sequenceNumber % 64)) {
                        sequenceNumber = (sequenceNumber + 1) % 0x1FFFFFFF;
                        if (!first) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (sequenceNumber == 0) {
                            throw new ArithmeticException("Session sequence number overload. Reset session");
                        }
                        first = false;
                    }
                    this.reserveTag(sequenceNumber % 64);
                    this.lastSequenceNumber = sequenceNumber;
                    QueueElement element = new QueueElement(sequenceNumber, request);
                    this.queue.add(element);
                    return sequenceNumber;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int tag) {
        this.run();
        List<QueueElement> list = this.queue;
        synchronized (list) {
            int i = 0;
            int index = -1;
            for (QueueElement element : this.queue) {
                if (element.getId() % 64 == tag) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == 0) {
                this.queue.remove(0);
                this.releaseTag(tag);
                while (this.queue.size() > 0 && this.queue.get(0).getRequest() == null) {
                    int additionalTag = this.queue.get(0).getId() % 64;
                    this.queue.remove(0);
                    this.releaseTag(additionalTag);
                }
            } else if (index > 0) {
                this.queue.get(index).setRequest(null);
            }
        }
    }

    public void removeAt(int index) {
        if (index >= this.queue.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds : " + index);
        }
        this.remove(this.queue.get(index).getId() % 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int sequenceNumber) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != sequenceNumber || element.getRequest() == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequenceNumber() {
        Object object = this.lastSequenceNumberLock;
        synchronized (object) {
            int sequenceNumber = (this.lastSequenceNumber + 1) % 0x1FFFFFFF;
            if (sequenceNumber == 0) {
                throw new ArithmeticException("Session sequence number overload. Reset session");
            }
            this.lastSequenceNumber = sequenceNumber;
            return sequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpmiCommandCoder getMessageFromQueue(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() % 64 != tag || element.getRequest() == null) continue;
                return element.getRequest();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageIndexFromQueue(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            int i = 0;
            for (QueueElement element : this.queue) {
                if (element.getId() % 64 == tag && element.getRequest() != null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getMessageRetries(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() % 64 != tag || element.getRequest() == null) continue;
                return element.getRetries();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageSequenceNumber(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() % 64 != tag || element.getRequest() == null) continue;
                return element.getId();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            boolean process = true;
            while (process && this.queue.size() > 0) {
                Date now = new Date();
                if (now.getTime() - this.queue.get(0).getTimestamp().getTime() > (long)this.timeout || this.queue.get(0).getRequest() == null) {
                    int tag = this.queue.get(0).getId() % 64;
                    boolean done = this.queue.get(0).getRequest() == null;
                    this.queue.remove(0);
                    logger.info((Object)("Removing message after timeout, tag: " + tag));
                    this.releaseTag(tag);
                    if (done) continue;
                    this.connection.notifyListeners(this.connection.getHandle(), tag, null, new IOException("Message timed out"));
                    continue;
                }
                process = false;
            }
        }
    }
}

