/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.sm;

import com.veraxsystems.vxipmi.coding.rmcp.RmcpDecoder;
import com.veraxsystems.vxipmi.sm.MachineObserver;
import com.veraxsystems.vxipmi.sm.actions.StateMachineAction;
import com.veraxsystems.vxipmi.sm.events.StateMachineEvent;
import com.veraxsystems.vxipmi.sm.states.SessionValid;
import com.veraxsystems.vxipmi.sm.states.State;
import com.veraxsystems.vxipmi.sm.states.Uninitialized;
import com.veraxsystems.vxipmi.transport.Messenger;
import com.veraxsystems.vxipmi.transport.UdpListener;
import com.veraxsystems.vxipmi.transport.UdpMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class StateMachine
implements UdpListener {
    private List<MachineObserver> observers;
    private State current;
    private Messenger messenger;
    private InetAddress remoteMachineAddress;
    private boolean initialized;

    public State getCurrent() {
        return this.current;
    }

    public void setCurrent(State current) {
        this.current = current;
        current.onEnter(this);
    }

    public StateMachine(Messenger messenger) {
        this.messenger = messenger;
        this.observers = new ArrayList<MachineObserver>();
        this.initialized = false;
    }

    public void sendMessage(byte[] message) throws IOException {
        UdpMessage udpMessage = new UdpMessage();
        udpMessage.setAddress(this.getRemoteMachineAddress());
        udpMessage.setPort(623);
        udpMessage.setMessage(message);
        this.messenger.send(udpMessage);
    }

    public InetAddress getRemoteMachineAddress() {
        return this.remoteMachineAddress;
    }

    public void doExternalAction(StateMachineAction action) {
        for (MachineObserver observer : this.observers) {
            if (observer == null) continue;
            observer.notify(action);
        }
    }

    public void start(InetAddress address) {
        this.messenger.register(this);
        this.remoteMachineAddress = address;
        this.setCurrent(new Uninitialized());
        this.initialized = true;
    }

    public void stop() {
        this.messenger.unregister(this);
        this.initialized = false;
    }

    public boolean isActive() {
        return this.initialized;
    }

    public void doTransition(StateMachineEvent event) {
        if (!this.initialized) {
            throw new NullPointerException("State machine not started");
        }
        this.current.doTransition(this, event);
    }

    @Override
    public void notifyMessage(UdpMessage message) {
        if (message.getAddress().equals(this.getRemoteMachineAddress())) {
            this.current.doAction(this, RmcpDecoder.decode(message.getMessage()));
        }
    }

    public void register(MachineObserver observer) {
        this.observers.add(observer);
    }

    public boolean isSessionChallenging() {
        return !this.initialized || this.getCurrent().getClass() == SessionValid.class;
    }
}

