/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.sm.states;

import com.veraxsystems.vxipmi.coding.Encoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.session.CloseSession;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilities;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv20Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.decoder.ProtocolDecoder;
import com.veraxsystems.vxipmi.coding.protocol.decoder.Protocolv20Decoder;
import com.veraxsystems.vxipmi.coding.protocol.encoder.Protocolv20Encoder;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import com.veraxsystems.vxipmi.sm.StateMachine;
import com.veraxsystems.vxipmi.sm.actions.ErrorAction;
import com.veraxsystems.vxipmi.sm.actions.MessageAction;
import com.veraxsystems.vxipmi.sm.events.Sendv20Message;
import com.veraxsystems.vxipmi.sm.events.SessionUpkeep;
import com.veraxsystems.vxipmi.sm.events.StateMachineEvent;
import com.veraxsystems.vxipmi.sm.events.Timeout;
import com.veraxsystems.vxipmi.sm.states.Authcap;
import com.veraxsystems.vxipmi.sm.states.State;

public class SessionValid
extends State {
    private CipherSuite cipherSuite;
    private int sessionId;

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public SessionValid(CipherSuite cipherSuite, int sessionId) {
        this.cipherSuite = cipherSuite;
        this.sessionId = sessionId;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Sendv20Message) {
            Sendv20Message event = (Sendv20Message)machineEvent;
            try {
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), event.getCommandCoder(), event.getSequenceNumber(), event.getSessionId()));
            }
            catch (Exception e) {
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else if (machineEvent instanceof SessionUpkeep) {
            SessionUpkeep event = (SessionUpkeep)machineEvent;
            try {
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), new GetChannelAuthenticationCapabilities(IpmiVersion.V20, IpmiVersion.V20, this.cipherSuite, PrivilegeLevel.Callback, TypeConverter.intToByte(14)), event.getSequenceNumber(), event.getSessionId()));
            }
            catch (Exception e) {
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Authcap());
        } else if (machineEvent instanceof com.veraxsystems.vxipmi.sm.events.CloseSession) {
            com.veraxsystems.vxipmi.sm.events.CloseSession event = (com.veraxsystems.vxipmi.sm.events.CloseSession)machineEvent;
            try {
                stateMachine.setCurrent(new Authcap());
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), new CloseSession(IpmiVersion.V20, this.cipherSuite, AuthenticationType.RMCPPlus, event.getSessionId()), event.getSequenceNumber(), event.getSessionId()));
            }
            catch (Exception e) {
                stateMachine.setCurrent(this);
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) != AuthenticationType.RMCPPlus) {
            return;
        }
        if (Protocolv20Decoder.decodeSessionID(message) == 0) {
            return;
        }
        Protocolv20Decoder decoder = new Protocolv20Decoder(this.cipherSuite);
        if (Protocolv20Decoder.decodePayloadType(message.getData()[1]) != PayloadType.Ipmi) {
            return;
        }
        if (Protocolv20Decoder.decodeSessionID(message) != this.sessionId) {
            return;
        }
        try {
            Ipmiv20Message message20 = (Ipmiv20Message)decoder.decode(message);
            if (message20.getSessionID() == this.sessionId) {
                stateMachine.doExternalAction(new MessageAction(message20));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

