/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.middleware.logger.Logger;
import java.util.Hashtable;
import java.util.Map;

public abstract class ServiceInvokeTransform {
    private static final Logger LOGGER = LoggerInit.LOGGER;

    public void register() {
        Helper.remove(this.serviceUniqueName());
        Helper.register(this);
    }

    public abstract String serviceInterfaceName();

    public final String serviceUniqueName() {
        return this.serviceInterfaceName() + ":" + this.serviceVersion();
    }

    public abstract String serviceVersion();

    public abstract Object[] transformRequest(String var1, Object[] var2, String[] var3) throws Exception;

    public abstract String[] transformRequestTypes(String var1, Object[] var2, String[] var3) throws Exception;

    public abstract Object transformResponse(String var1, Object[] var2, String[] var3, Object var4) throws Exception;

    public static class Helper {
        private static Map<String, ServiceInvokeTransform> registry = new Hashtable<String, ServiceInvokeTransform>();

        public static ServiceInvokeTransform find(String serviceUniqueName) {
            return registry.get(serviceUniqueName);
        }

        public static void register(ServiceInvokeTransform transform) {
            LOGGER.warn("\u6ce8\u518c\u52a8\u6001\u670d\u52a1TOP[" + transform.serviceUniqueName() + "]");
            registry.put(transform.serviceUniqueName(), transform);
        }

        public static void remove(String serviceUniqueName) {
            registry.remove(serviceUniqueName);
        }
    }
}

