/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.address;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.address.AddressPool;
import com.taobao.hsf.address.AddressProfiler;
import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.route.component.AppAddressFilterManager;
import com.taobao.hsf.route.flowcontrol.FlowControlRule;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.route.service.RouteService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.weighting.WeightingRule;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class AddressComponent
implements AddressService {
    private final ConfigurationService configurationService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private final RouteService routeService = HSFServiceContainer.getInstance(RouteService.class, this.configurationService.getRouteType());
    private final AtomicBoolean addressProfilerStarted = new AtomicBoolean(false);
    private final AddressProfiler addressProfiler = new AddressProfiler();
    private final AddressPool addressPool = new AddressPool();
    private AppAddressFilterManager filterManager = AppAddressFilterManager.instance;

    @Override
    public void initAddressBucket(String serviceName, EnumConfigStyle configStyle) {
        this.addressPool.initAddressBucket(serviceName, configStyle);
    }

    @Override
    public String getServiceAddress(String serviceUniqueName, String methodName, String[] paramTypeStrs, Object[] args) {
        List<String> addresses = this.addressPool.getArgsAddresses(serviceUniqueName, methodName, paramTypeStrs, args);
        addresses = this.filterManager.filterAddress(addresses, serviceUniqueName, methodName, paramTypeStrs, args);
        return this.routeService.getServiceAddress(addresses);
    }

    @Override
    public List<String> getServiceAddresses(String serviceUniqueName) {
        return this.addressPool.getAddressBucket(serviceUniqueName).getAllAddresses();
    }

    @Override
    public List<String> getServiceAddressFiltered(String serviceUniqueName, String methodName, String[] paramTypeStrs, Object[] args) {
        List<String> addresses = this.addressPool.getArgsAddresses(serviceUniqueName, methodName, paramTypeStrs, args);
        addresses = this.filterManager.filterAddress(addresses, serviceUniqueName, methodName, paramTypeStrs, args);
        return addresses;
    }

    @Override
    public Object getServiceAddressBucket(String serviceUniqueName) {
        return this.addressPool.getAddressBucket(serviceUniqueName);
    }

    @Override
    public void setServiceAddresses(String serviceUniqueName, List<String> addresses) {
        this.addressPool.changeAddressList(serviceUniqueName, addresses);
    }

    @Override
    public void setServiceRouteRule(String serviceUniqueName, RouteRule rawRouteRuleObj) {
        this.addressPool.changeRouteRule(serviceUniqueName, rawRouteRuleObj);
    }

    @Override
    public void setFlowControlRule(String serviceUniqueName, FlowControlRule rawRule) {
        this.addressPool.changeFlowcontrolRule(serviceUniqueName, rawRule);
    }

    @Override
    public void setGlobalRule(GlobalRule globalRule) {
        this.addressPool.changeGlobalRule(globalRule);
    }

    @Override
    public AddressPool getServiceAddressPool() {
        return this.addressPool;
    }

    @Override
    public void setWeightRule(String serviceUniqueName, WeightingRule weightRule) {
        this.addressPool.changeWeightRule(serviceUniqueName, weightRule);
    }

    @Override
    public void setRtWeightMap(String serviceUniqueName, Map<String, Integer> rtWeightMap) {
        this.addressPool.changeRtWeightMap(serviceUniqueName, rtWeightMap);
    }

    @Override
    public void invalidateAddress(String serviceUniqueName, String targetURL) {
        if (this.addressProfilerStarted.compareAndSet(false, true)) {
            this.addressProfiler.startProfiler();
        }
        this.addressProfiler.addInvalidAddress(serviceUniqueName, targetURL);
    }

    @Override
    public String getAddressByIp(String serviceUniqueName, String ip) {
        return this.addressPool.getAddressBucket(serviceUniqueName).getAddressByIp(ip);
    }
}

