/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.address;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.NamedThreadFactory;
import com.taobao.hsf.address.AddressBucket;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.route.flowcontrol.FlowControlRule;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.weighting.WeightingRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AddressPool {
    private final ConcurrentMap<String, AddressBucket> pool = new ConcurrentHashMap<String, AddressBucket>();
    public final ExecutorService addressAndRuleExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("HSF-AddressAndRule"));
    private final BlockingQueue<Object> signalBell = new ArrayBlockingQueue<Object>(1);
    private volatile GlobalRule globalRule = null;
    private final String unitName;

    public AddressPool() {
        this(null);
    }

    public AddressPool(String unitName) {
        this.unitName = unitName;
        this.addressAndRuleExecutor.execute(new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        if (AddressPool.this.signalBell.poll(10000L, TimeUnit.SECONDS) == null) continue;
                        Iterator iterator = AddressPool.this.pool.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block4;
                            AddressBucket addressBucket = (AddressBucket)iterator.next();
                            addressBucket.refreshAddress();
                        }
                    }
                    catch (Throwable e) {
                        LoggerInit.LOGGER.error("", "[address pool] Refresh ", e);
                    }
                }
            }
        });
    }

    public Map<String, List<String>> addressSnapshot() {
        HashMap<String, List<String>> snapshot = new HashMap<String, List<String>>();
        for (String key : this.pool.keySet()) {
            AddressBucket bucket = (AddressBucket)this.pool.get(key);
            snapshot.put(key + "_ALL", bucket.getAllAddresses());
            snapshot.put(key + "_LOCAL", bucket.getLocalAddresses());
            snapshot.put(key + "_INVALID", bucket.getInvalidAddresses());
            snapshot.put(key, bucket.getAvailableAddresses());
        }
        return snapshot;
    }

    public AddressBucket getAddressBucket(String serviceUniqueName) {
        AddressBucket bucket = (AddressBucket)this.pool.get(serviceUniqueName);
        if (bucket != null) {
            return bucket;
        }
        AddressBucket newBucket = this.unitName == null ? new AddressBucket(serviceUniqueName, this, ApplicationModel.instance().getConfigStyleOfConsumer(serviceUniqueName)) : new AddressBucket(this.unitName, serviceUniqueName, this, ApplicationModel.instance().getConfigStyleOfConsumer(serviceUniqueName));
        bucket = this.pool.putIfAbsent(serviceUniqueName, newBucket);
        if (bucket == null) {
            return newBucket;
        }
        return bucket;
    }

    public Collection<String> listServices() {
        HashSet<String> duplicate = new HashSet<String>();
        duplicate.addAll(this.pool.keySet());
        return duplicate;
    }

    public String toString() {
        return "AddressPool [pool=" + this.pool + "]";
    }

    public List<String> getArgsAddresses(String serviceUniqueName, String methodName, String[] parameterTypes, Object[] args) {
        return this.getAddressBucket(serviceUniqueName).getArgsAddresses(methodName, parameterTypes, args);
    }

    public GlobalRule getGlobalRule() {
        return this.globalRule;
    }

    public void changeAddressList(String serviceName, List<String> list) {
        this.getAddressBucket(serviceName).setAllAddresses(list);
        this.signalBell.offer(new Object());
    }

    public void changeDubboAddressList(String serviceName, List<String> list) {
        this.getAddressBucket(serviceName).setAllDubboAddresses(list);
        this.signalBell.offer(new Object());
    }

    public void changeFlowcontrolRule(String serviceName, FlowControlRule rule) {
        this.getAddressBucket(serviceName).setFlowControlRule(rule);
        this.signalBell.offer(new Object());
    }

    public void changeGlobalRule(GlobalRule globalRule) {
        this.globalRule = globalRule;
        for (AddressBucket bucket : this.pool.values()) {
            bucket.needRefresh.set(true);
        }
        this.signalBell.offer(new Object());
    }

    public void addInvalidAddress(String serviceName, String invlidAddress) {
        AddressBucket addressBucket = this.getAddressBucket(serviceName);
        addressBucket.addInvalidAddress(serviceName, invlidAddress);
        this.signalBell.offer(new Object());
    }

    public void removeInvalidAddress(String serviceUniqueName, List<String> recoverList) {
        AddressBucket addressBucket = this.getAddressBucket(serviceUniqueName);
        addressBucket.removeInvalidAddressesAndRefresh(recoverList);
        this.signalBell.offer(new Object());
    }

    public void changeRouteRule(String serviceUniqueName, RouteRule rule) {
        this.getAddressBucket(serviceUniqueName).setRouteRule(rule);
        this.signalBell.offer(new Object());
    }

    public void initAddressBucket(String serviceName, EnumConfigStyle configStyle) {
        this.pool.putIfAbsent(serviceName, new AddressBucket(serviceName, this, configStyle));
    }

    public void changeWeightRule(String serviceUniqueName, WeightingRule weightRule) {
        this.getAddressBucket(serviceUniqueName).setWeightRule(weightRule);
        this.signalBell.offer(new Object());
    }

    public void changeRtWeightMap(String serviceUniqueName, Map<String, Integer> rtMap) {
        this.getAddressBucket(serviceUniqueName).setRtWeightMap(rtMap);
        this.signalBell.offer(new Object());
    }
}

