/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.address;

import com.taobao.hsf.address.AddressBucket;
import com.taobao.hsf.address.AddressPool;
import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.address.unit.UnitAddressService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.service.RPCProtocolService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.weighting.WeightingRule;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class AddressProfiler
implements Runnable {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final int SLEEP_TIME = 3000;
    private static final int MAX_SLEEP_TIME = 3030;
    private volatile UnitAddressService unitAddressService;
    private volatile RPCProtocolService rpcProtocolService;
    private volatile AddressPool addressPool;
    private long lastRefreshTime = System.currentTimeMillis();

    public void startProfiler() {
        this.unitAddressService = HSFServiceContainer.getInstance(UnitAddressService.class);
        this.addressPool = HSFServiceContainer.getInstance(AddressService.class).getServiceAddressPool();
        this.rpcProtocolService = HSFServiceContainer.getInstance(RPCProtocolService.class);
        Thread thread = new Thread(this);
        thread.setName("HSF-AddressProfiler");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            long elapsed;
            if ((elapsed = System.currentTimeMillis() - this.lastRefreshTime) > 3030L) {
                LOGGER.warn(MessageFormat.format("[AddressProfiler] Sleeped {0} ms.", elapsed));
            }
            try {
                for (String serviceUniqueName : this.addressPool.listServices()) {
                    List<String> allAddresses;
                    AddressBucket addressBucket = this.addressPool.getAddressBucket(serviceUniqueName);
                    WeightingRule weightRule = addressBucket.getWeightRule();
                    if (weightRule != null && weightRule.getExpireTime() < System.currentTimeMillis()) {
                        addressBucket.setWeightRule(null);
                    }
                    if ((allAddresses = addressBucket.getAllAddresses()).isEmpty()) continue;
                    ArrayList<String> needDeleteList = new ArrayList<String>();
                    List<String> invalidAddresses = addressBucket.getInvalidAddresses();
                    for (String address : invalidAddresses) {
                        if (allAddresses.contains(address)) {
                            if (!this.rpcProtocolService.validTarget(address)) continue;
                            needDeleteList.add(address);
                            LOGGER.info(MessageFormat.format("[AddressProfiler] Recover service address: {0} from black list.", address));
                            continue;
                        }
                        needDeleteList.add(address);
                    }
                    if (needDeleteList.isEmpty()) continue;
                    if (this.unitAddressService != null) {
                        this.unitAddressService.removeInvalidAddressesAndRefresh(serviceUniqueName, needDeleteList);
                    }
                    this.addressPool.removeInvalidAddress(serviceUniqueName, needDeleteList);
                }
            }
            catch (Throwable e) {
                LOGGER.error("", "AddressProfiler Thread Error!", e);
            }
            this.lastRefreshTime = System.currentTimeMillis();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void addInvalidAddress(String serviceUniqueName, String invalidAddress) {
        this.addressPool.addInvalidAddress(serviceUniqueName, invalidAddress);
        if (this.unitAddressService != null) {
            this.unitAddressService.addInvalidAddress(serviceUniqueName, invalidAddress);
        }
    }
}

