/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.app.api.util;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessService;
import com.taobao.hsf.remoting.service.GenericService;
import com.taobao.hsf.tbremoting.invoke.HSFResponseCallback;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.HSFServiceTargetUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;

public class HSFApiConsumerBean {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final ServiceMetadata metadata = new ServiceMetadata(false);
    private final AtomicBoolean inited = new AtomicBoolean();
    private List<String> asyncallMethods;

    public Object getObject() throws Exception {
        return this.metadata.getTarget();
    }

    public void init(long timeout) throws Exception {
        this.syncInit(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncInit(long timeout) throws Exception {
        if (this.metadata.getNeedNotify().compareAndSet(false, true)) {
            Object object = this.metadata.syncLock;
            synchronized (object) {
                this.init();
                this.metadata.syncLock.wait(timeout);
            }
        }
    }

    public void init() throws Exception {
        if (!this.inited.compareAndSet(false, true)) {
            LOGGER.warn(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0020", (String)"Biz-Problem", (String)("HSF Duplicate init\uff1a" + this.metadata.getUniqueName())));
            return;
        }
        if (HSFServiceTargetUtil.isGeneric(this.metadata.getGeneric())) {
            this.metadata.setIfClazz(GenericService.class);
        } else if (this.metadata.getIfClazz() == null) {
            throw new IllegalArgumentException("HSFApiConsumerBean.ServiceMetadata.ifClazz is null[" + this.metadata.getInterfaceName() + "].");
        }
        if (this.asyncallMethods != null) {
            for (String desc : this.asyncallMethods) {
                this.parseAsyncFunc(desc);
            }
        }
        ProcessService processService = HSFServiceContainer.getInstance(ProcessService.class);
        try {
            this.metadata.setTarget(processService.consume(this.metadata));
            LOGGER.warn("HSF consume [{}:{}] success.", this.metadata.getInterfaceName(), new Object[]{this.metadata.getVersion()});
        }
        catch (Exception e) {
            LOGGER.error("HSF consume [{}:{}] failed.", this.metadata.getInterfaceName(), this.metadata.getVersion(), (Throwable)e);
            throw e;
        }
        int waitTime = this.metadata.getMaxWaitTimeForCsAddress();
        if (waitTime > 0) {
            try {
                this.metadata.getCsAddressCountDownLatch().await(waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setAsyncallMethods(List<String> asyncallMethods) {
        this.asyncallMethods = asyncallMethods;
    }

    public void setGroup(String group) {
        this.metadata.setGroup(group);
        this.metadata.setDefaultGroup(group);
    }

    public void setCallbackInvoker(Object callbackInvoker) {
        this.metadata.setCallbackInvoker(callbackInvoker);
    }

    public void setInterfaceName(String interfaceName) {
        this.metadata.setInterfaceName(interfaceName.trim());
        try {
            Class<?> clazz = Class.forName(interfaceName.trim());
            this.metadata.setIfClazz(clazz);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("If not generic invoke, it will not be OK", new Object[]{e});
        }
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.metadata.setIfClazz(interfaceClass);
        this.metadata.setInterfaceName(interfaceClass.getName());
    }

    public void setMaxThreadPool(String poolSize) {
        if (poolSize != null && poolSize.length() > 0) {
            this.metadata.setConsumerMaxPoolSize(Integer.parseInt(poolSize.trim()));
        }
    }

    public void setMethodSpecials(MethodSpecial[] methodSpecials) {
        this.metadata.setMethodSpecials(methodSpecials);
    }

    public void setRPCProtocols(Map<String, Properties> rpcProtocols) {
        LOGGER.error("", "no longer support RPCProtocols property in HSF2");
    }

    public void setTarget(String target) {
        if (StringUtils.isNotBlank((String)target)) {
            this.metadata.addProperty("target", target);
        }
    }

    public void setVersion(String version) {
        this.metadata.setVersion(version.trim());
    }

    public void setConnectionNum(int connectionNum) {
        this.metadata.setConnectionNum(connectionNum);
    }

    private void parseAsyncFunc(String desc) {
        String[] methodDescs;
        ServiceMetadata.AsyncallMethod amethod = new ServiceMetadata.AsyncallMethod(this.metadata);
        if (desc.indexOf(";") == -1) {
            amethod.setName(desc);
            amethod.setType("SYNC");
            return;
        }
        for (String methodDesc : methodDescs = desc.split(";")) {
            String[] methodDescProps = methodDesc.split(":");
            String propName = methodDescProps[0];
            String propValue = methodDescProps[1];
            if ("name".equalsIgnoreCase(propName)) {
                amethod.setName(propValue);
                continue;
            }
            if ("type".equalsIgnoreCase(propName)) {
                if ("reliable".equalsIgnoreCase(propValue)) {
                    throw new RuntimeException("no long support reliable invoke. Please use notify directly.");
                }
                amethod.setType(propValue);
                continue;
            }
            if (!"listener".equalsIgnoreCase(propName)) continue;
            amethod.setCallback(propValue.trim());
            amethod.setType("callback");
        }
        if (amethod.isCallback()) {
            String callBackClassName = amethod.getCallback();
            if (callBackClassName == null || callBackClassName.isEmpty()) {
                throw new RuntimeException("listener is missing for async mehtod : " + amethod.getName());
            }
            try {
                Class<?> callbackClazz = Class.forName(callBackClassName);
                Object callback = callbackClazz.newInstance();
                if (!(callback instanceof HSFResponseCallback)) {
                    throw new RuntimeException("listener must implement HSFResponseCallback, check config for async method : " + amethod.getName());
                }
                amethod.setCallbackInstance(callback);
            }
            catch (Exception e) {
                throw new RuntimeException("Create callback listener failed, callback:" + amethod.getCallback(), e);
            }
        }
        Method asyncFunc = null;
        String asyncFuncName = amethod.getName();
        Class<?> ifClazz = this.metadata.getIfClazz();
        Method[] allFunc = ifClazz.getMethods();
        for (int idx = 0; idx < allFunc.length && asyncFunc == null; ++idx) {
            if (allFunc[idx].getName().equalsIgnoreCase(asyncFuncName)) {
                asyncFunc = allFunc[idx];
                amethod.setMethod(asyncFunc);
                this.metadata.addAsyncallMethod(amethod);
                continue;
            }
            if (!allFunc[idx].getName().equalsIgnoreCase("$invoke")) continue;
            asyncFunc = allFunc[idx];
            this.metadata.addAsyncallMethod(amethod);
        }
        if (null == asyncFunc) {
            throw new RuntimeException("Cant find method:" + ifClazz.getName() + "." + asyncFuncName + "");
        }
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public void setGeneric(String generic) {
        this.metadata.setGeneric(generic);
    }

    public void setSecureKey(String secureKey) {
        this.metadata.setSecureKey(secureKey);
    }

    public void setMaxWaitTimeForCsAddress(int timeout) {
        this.metadata.setMaxWaitTimeForCsAddress(timeout);
    }

    public void setClientTimeout(int clientTimeout) {
        this.metadata.addProperty("_TIMEOUT", "" + clientTimeout);
    }
}

