/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.component;

import com.taobao.hsf.configuration.component.ConfigurationComponentUtil;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.util.HSFConstants;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class ConfigurationComponent
implements ConfigurationService {
    private final Properties props = ConfigurationComponentUtil.initProperties("hsfconfig.properties");
    private int hsfServerPort = this.getIntegerProp("hsf.server.port", 12200);
    private String hsfServerIp = this.getStringProp("hsf.server.ip", "");
    private int httpServerPort = this.getIntegerProp("hsf.http.port", 12200);
    private int hsfServerMaxPoolSize = this.getIntegerProp("hsf.server.max.poolsize", 600);
    private int hsfServerMinPoolSize = this.getIntegerProp("hsf.server.min.poolsize", 50);
    private long shuthookWaittime = this.getIntegerProp("hsf.shuthook.wait", 10000).intValue();
    private boolean localCallEnable = this.getBooleanProp("hsf.client.localcall", true);
    private boolean httpEnable = this.getBooleanProp("hsf.http.enable", false);
    private boolean httpPublish = this.getBooleanProp("hsf.http.publish", false);
    private String hsfVersion = this.getStringFromProp("hsf.version", "", this.props);
    private String registryType = "cs";
    private String registryAddress;
    private String governanceType = "diamond";
    private String governanceAddress;
    private boolean delayedPublish = this.getBooleanProp("hsf.publish.delayed", false);
    private String routeType = this.getStringProp("hsf.route.type", "random");
    private boolean rtOn = this.getBooleanProp("hsf.rt.on", false);
    private int rtGlobalThreshold = this.getIntegerProp("hsf.rt.global.threshold", 10000);
    private int rtThreadThreshold = this.getIntegerProp("hsf.rt.thread.threshold", 1000);
    private boolean isRtCollect = this.getBooleanProp("hsf.rt.collect", true);
    private boolean isClientRtCollect = this.getBooleanProp("hsf.client.rt.collect", false);

    public ConfigurationComponent() {
        String tmpGovernanceAddress;
        int index;
        String tmpRegistryAddress = this.getStringProp("hsf.registry.address", null);
        if (tmpRegistryAddress != null) {
            index = tmpRegistryAddress.indexOf("://");
            if (index > 0) {
                this.registryType = tmpRegistryAddress.substring(0, index);
                this.registryAddress = tmpRegistryAddress.substring(index + 3);
            } else {
                this.registryType = tmpRegistryAddress;
            }
        }
        if ((tmpGovernanceAddress = this.getStringProp("hsf.governance.type", null)) != null) {
            index = tmpGovernanceAddress.indexOf("://");
            if (index > 0) {
                this.governanceType = tmpGovernanceAddress.substring(0, index);
                this.governanceAddress = tmpGovernanceAddress.substring(index + 3);
            } else {
                this.governanceType = tmpGovernanceAddress;
            }
        }
    }

    private final String getStringProp(String key, String defaultValue) {
        String v = this.getStringFromProp(key, null, System.getProperties());
        if (null == v) {
            v = this.getStringFromProp(key, null, this.props);
        }
        return null == v ? defaultValue : v;
    }

    private final Integer getIntegerProp(String key, Integer defaultValue) {
        Integer v = this.getIntegerFromProp(key, null, System.getProperties());
        if (null == v) {
            v = this.getIntegerFromProp(key, null, this.props);
        }
        return null == v ? defaultValue : v;
    }

    private final Boolean getBooleanProp(String key, Boolean defaultValue) {
        Boolean v = this.getBooleanFromProp(key, null, System.getProperties());
        if (null == v) {
            v = this.getBooleanFromProp(key, null, this.props);
        }
        return null == v ? defaultValue : v;
    }

    private final String getStringFromProp(String key, String defaultValue, Properties properties) {
        String ret = properties.getProperty(key, defaultValue);
        return ConfigurationComponentUtil.isBlank(ret) ? defaultValue : ret.trim();
    }

    private final Integer getIntegerFromProp(String key, Integer defaultValue, Properties properties) {
        String ret = this.getStringFromProp(key, null, properties);
        try {
            return null == ret ? defaultValue : Integer.valueOf(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private final Boolean getBooleanFromProp(String key, Boolean defaultValue, Properties properties) {
        String ret = this.getStringFromProp(key, null, properties);
        try {
            return null == ret ? defaultValue : Boolean.valueOf(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    @Override
    public boolean isDelayedPublish() {
        return this.delayedPublish;
    }

    @Override
    public int getHSFServerMaxPoolSize() {
        return this.hsfServerMaxPoolSize;
    }

    @Override
    public int getHSFServerMinPoolSize() {
        return this.hsfServerMinPoolSize;
    }

    @Override
    public int getHSFServerPort() {
        return this.hsfServerPort;
    }

    @Override
    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    @Override
    public boolean isLocalCallEnable() {
        return this.localCallEnable;
    }

    @Override
    public void setHSFServerMaxPoolSize(int maxPoolSize) {
        this.hsfServerMaxPoolSize = maxPoolSize;
    }

    @Override
    public void setHSFServerMinPoolSize(int minPoolSize) {
        this.hsfServerMinPoolSize = minPoolSize;
    }

    @Override
    public void setLocalCallEnable(boolean localCallEnable) {
        this.localCallEnable = localCallEnable;
    }

    @Override
    public String getHsfVersion() {
        return this.hsfVersion;
    }

    @Override
    public String getServerIp() {
        return this.hsfServerIp;
    }

    @Override
    public String getDefaultValue(String key) {
        return this.props.getProperty(key);
    }

    @Override
    public String getPreferedSerializer() {
        String serializer = System.getProperty("hsf.serializer");
        if (!StringUtils.isBlank((String)serializer) && Arrays.asList(HSFConstants.SUPPORTED_SERIALIZER).contains(serializer)) {
            return serializer;
        }
        return "hessian2";
    }

    @Override
    public boolean isHttpEnable() {
        return this.httpEnable;
    }

    @Override
    public String getRegistryType() {
        return this.registryType;
    }

    @Override
    public String getRegistryAddress() {
        return this.registryAddress;
    }

    @Override
    public String getGovernanceType() {
        return this.governanceType;
    }

    @Override
    public long getshutdownHookWaitTime() {
        return this.shuthookWaittime;
    }

    @Override
    public String getValue(String key) {
        return this.getStringProp(key, null);
    }

    @Override
    public String getGovernanceAddress() {
        return this.governanceAddress;
    }

    @Override
    public String getRouteType() {
        return this.routeType;
    }

    @Override
    public boolean isHttpPublish() {
        return this.httpPublish;
    }

    @Override
    public boolean isRtOn() {
        return this.rtOn;
    }

    @Override
    public int getRtThreadThreshold() {
        return this.rtThreadThreshold;
    }

    @Override
    public int getRtGlobalThreshold() {
        return this.rtGlobalThreshold;
    }

    @Override
    public boolean isRtCollect() {
        return this.isRtCollect;
    }

    @Override
    public boolean isClientRtCollect() {
        return this.isClientRtCollect;
    }
}

