/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.component;

import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.address.unit.UnitAddressService;
import com.taobao.hsf.configuration.parser.GlobalRuleParser;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.globalrule.DubboRegRule;
import com.taobao.hsf.globalrule.EagleEyeRule;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.globalrule.LogLevelRule;
import com.taobao.hsf.governance.GovernanceListener;
import com.taobao.hsf.governance.GovernanceService;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.process.service.ProcessHookServiceAdapter;
import com.taobao.hsf.util.AppInfoUtils;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;

public class GlobalConfigurationComponent
extends ProcessHookServiceAdapter
implements GovernanceListener {
    private static final Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private static final String GLOBAL_RULE_DATAID = "HSF.GLOBAL.CONFIGURATION";
    private static final String GLOBAL_RULE_GROUP = "HSF";
    private static final LogService logService = HSFServiceContainer.getInstance(LogService.class);
    private final AtomicBoolean processed = new AtomicBoolean(false);
    private final AddressService addressService = HSFServiceContainer.getInstance(AddressService.class);
    private final UnitAddressService unitAddressService = HSFServiceContainer.getInstance(UnitAddressService.class);
    private final GovernanceService governanceService = HSFServiceContainer.getInstance(GovernanceService.class, HSFServiceContainer.getInstance(ConfigurationService.class).getGovernanceType());

    @Override
    public void afterConsume(ServiceMetadata metadata) {
        if (this.processed.compareAndSet(false, true)) {
            this.subscribeGlobalRule();
        }
    }

    @Override
    public void afterPublish(ServiceMetadata metadata) {
        if (this.processed.compareAndSet(false, true)) {
            this.subscribeGlobalRule();
        }
    }

    private void processConfigInfo(String configInfo) {
        LOGGER_CONFIG.info(MessageFormat.format("[Global Configuration] Global rule received [{0}]", configInfo));
        GlobalRule globalRule = null;
        try {
            GlobalRuleParser parser = new GlobalRuleParser();
            globalRule = parser.parse(configInfo);
        }
        catch (Throwable t) {
            LOGGER_CONFIG.info(MessageFormat.format("[Global Configuration] Global rule [{0}] parsed failed: {1}", configInfo, t));
            return;
        }
        if (globalRule == null) {
            LOGGER_CONFIG.warn("[Global Configuration] Invalid global configuration received.");
            return;
        }
        LOGGER_CONFIG.info(MessageFormat.format("[Global Configuration] Global rule parsed OK: {0}", globalRule));
        this.eagleRuleAction(globalRule);
        this.virtualCmRuleAction(globalRule);
        this.logLevelRuleAction(globalRule);
        this.dubboRegRuleAction(globalRule);
    }

    private void dubboRegRuleAction(GlobalRule globalRule) {
        DubboRegRule dubboRegRule = globalRule.getDubboRegRule();
        if (dubboRegRule == null) {
            LOGGER_CONFIG.info("[Global Configuration] no DubboRegRule available");
            return;
        }
        this.addressService.setGlobalRule(globalRule);
        if (this.unitAddressService != null) {
            this.unitAddressService.setGlobalRule(globalRule);
        }
    }

    private void logLevelRuleAction(GlobalRule globalRule) {
        LogLevelRule logLevelRule = globalRule.getLogLevelRule();
        if (logLevelRule == null) {
            return;
        }
        String levelStr = null;
        String localIp = InetAddressUtil.getIP();
        LOGGER_CONFIG.info("LogLevelRule : localip is " + localIp);
        if (localIp != null && (levelStr = logLevelRule.getIpLevel(localIp)) != null) {
            LoggerInit.changeLogLevel(levelStr);
            return;
        }
        String app = AppInfoUtils.getAppName();
        LOGGER_CONFIG.info("LogLevelRule : appname is " + app);
        if (app != null && (levelStr = logLevelRule.getAppLevel(app)) != null) {
            LoggerInit.changeLogLevel(levelStr);
            return;
        }
        levelStr = logLevelRule.getGlobalLevelStr();
        if (levelStr != null) {
            LoggerInit.changeLogLevel(levelStr);
            return;
        }
    }

    public void virtualCmRuleAction(GlobalRule globalRule) {
        try {
            if (globalRule == null || globalRule.getVirtualCmRule() == null) {
                return;
            }
            this.addressService.setGlobalRule(globalRule);
            if (this.unitAddressService != null) {
                this.unitAddressService.setGlobalRule(globalRule);
            }
        }
        catch (Throwable t) {
            LOGGER_CONFIG.warn("[Global Configuration] execute virtualCmRule action error", new Object[]{t});
        }
    }

    public void eagleRuleAction(GlobalRule globalRule) {
        try {
            String appName = AppInfoUtils.getAppName();
            if (appName == null) {
                LOGGER_CONFIG.warn("[Global Configuration] Can not set eagleeye switch: application name is null.");
                return;
            }
            EagleEyeRule eagleEyeRule = globalRule.getEagleEyeRule();
            if (eagleEyeRule != null) {
                if (eagleEyeRule.isRpcOff(appName)) {
                    logService.turnRpcOff();
                } else {
                    logService.turnRpcOn();
                }
                if (eagleEyeRule.isBizOff(appName)) {
                    logService.turnBizOff();
                } else {
                    logService.turnBizOn();
                }
                if (eagleEyeRule.getSampleInterval() >= 0) {
                    logService.setSampleInterval(eagleEyeRule.getSampleInterval());
                }
                logService.setClusterTestEnabled(eagleEyeRule.isClusterTestEnabled());
                logService.setUserDataEnabled(eagleEyeRule.isUserDataEnabled());
                logService.setLogDumpEnabled(eagleEyeRule.isDump());
            } else {
                logService.setLogDumpEnabled(false);
            }
        }
        catch (Throwable t) {
            LOGGER_CONFIG.warn("[Global Configuration] execute eagleEyeRule action error", new Object[]{t});
        }
    }

    private void subscribeGlobalRule() {
        if (this.governanceService != null) {
            String dataId = GLOBAL_RULE_DATAID;
            String group = GLOBAL_RULE_GROUP;
            this.governanceService.getConfig(GLOBAL_RULE_DATAID, null, GLOBAL_RULE_GROUP, this, "[Global Configuration] Process configuration infomation error.");
        }
    }

    @Override
    public void process(String uniqueName, String configInfo) {
        this.processConfigInfo(configInfo);
    }
}

