/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.parser;

import com.taobao.hsf.configuration.component.ConfigPropertiesRule;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.AbstractRuleParser;
import com.taobao.hsf.rule.RuleParseException;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConfigPropertiesRuleParser
extends AbstractRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER_CONFIG;
    public static final String RULE_SURFIX = ".CONFIGPROPERTIES";

    @Override
    public String getRuleName() {
        return "ConfigProperties";
    }

    @Override
    public ConfigPropertiesRule parse(String rawRule) throws RuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        int beginIndex = rawRule.indexOf(64);
        String rule = rawRule.substring(beginIndex + 1);
        if (!rule.contains("<")) {
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            ConfigPropertiesRule configPropRule = new ConfigPropertiesRule();
            Properties props = new Properties();
            Document doc = this.documentBuilder.parse(is);
            Element root = doc.getDocumentElement();
            if (!"properties".equals(root.getNodeName())) {
                LOGGER.warn("[ConfigPropertiesRuleParser] Invalid rule: 'properties' node needed.");
                return null;
            }
            NodeList entryList = root.getChildNodes();
            for (int i = 0; i < entryList.getLength(); ++i) {
                Node entryNode = entryList.item(i);
                if (entryNode.getNodeType() != 1) continue;
                if (!"entry".equals(entryNode.getNodeName())) {
                    LOGGER.warn("[ConfigPropertiesRuleParser] Invalid node: " + entryNode.getNodeName());
                    return null;
                }
                NamedNodeMap attrs = entryNode.getAttributes();
                if (null == attrs) {
                    LOGGER.warn("[ConfigPropertiesRuleParser] need 'key' attribute");
                    return null;
                }
                Node keyNode = attrs.getNamedItem("key");
                if (null == keyNode) {
                    LOGGER.warn("[ConfigPropertiesRuleParser] need 'key' attribute");
                    return null;
                }
                String key = keyNode.getNodeValue();
                String value = entryNode.getTextContent().trim();
                LOGGER.warn("[ConfigPropertiesRuleParser]  " + key + " = " + value);
                if (key == null || value == null || key.isEmpty() || value.isEmpty()) continue;
                props.setProperty(key, value);
            }
            configPropRule.setConfigProperties(props);
            return configPropRule;
        }
        catch (InvalidPropertiesFormatException e) {
            LOGGER.warn("[ConfigPropertiesRuleParser] Invalid properties rule ", new Object[]{e});
        }
        catch (IOException e) {
            LOGGER.warn("[ConfigPropertiesRuleParser] parse properties rule failed ", new Object[]{e});
        }
        catch (Exception e) {
            throw new RuleParseException("[CloudRule Parser]", "Cloud Rule parsed failed", e);
        }
        return null;
    }
}

