/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.parser;

import com.taobao.hsf.configuration.parser.DubboRegRuleParser;
import com.taobao.hsf.configuration.parser.EagleRuleParser;
import com.taobao.hsf.configuration.parser.LogLevelRuleParser;
import com.taobao.hsf.configuration.parser.SubRuleParser;
import com.taobao.hsf.configuration.parser.VirtualCmRuleParser;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.RuleParseException;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String TAG_RULES = "rules";
    private List<SubRuleParser> subRuleParsers = new ArrayList<SubRuleParser>();
    private DocumentBuilder documentBuilder;

    public GlobalRuleParser() {
        this.subRuleParsers.add(new EagleRuleParser());
        this.subRuleParsers.add(new VirtualCmRuleParser());
        this.subRuleParsers.add(new LogLevelRuleParser());
        this.subRuleParsers.add(new DubboRegRuleParser());
        this.documentBuilder = null;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("", "error create document builder!", (Throwable)e);
        }
    }

    public GlobalRule parse(String rawRule) throws RuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            GlobalRule globalRuleHolder = new GlobalRule();
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            if (!rule.contains("<")) {
                return globalRuleHolder;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            Element root = doc.getDocumentElement();
            if (!TAG_RULES.equals(root.getNodeName())) {
                LOGGER.error("", "[GlobalRule Parser] Invalid rule: 'rules' node needed.");
                return null;
            }
            NodeList nodeList = root.getChildNodes();
            block2: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (1 != node.getNodeType()) continue;
                for (SubRuleParser subRuleParser : this.subRuleParsers) {
                    if (!subRuleParser.accept(node)) continue;
                    subRuleParser.parse(node, globalRuleHolder);
                    continue block2;
                }
            }
            return globalRuleHolder;
        }
        catch (Exception e) {
            throw new RuleParseException("GlobalRule", "Global Rule parsed failed", e);
        }
    }
}

