/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.configuration.parser;

import com.taobao.hsf.configuration.parser.SubRuleParser;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.globalrule.LogLevelRule;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogLevelRuleParser
implements SubRuleParser {
    private static final String TAG_LOG_LEVEL = "logLevel";
    private static final String TAG_GLOBAL_LEVEL = "globalLevel";
    private static final String TAG_IP_LEVEL = "ipLevel";
    private static final String TAG_IP = "ip";
    private static final String TAG_LEVEL = "level";
    private static final String TAG_APP_LEVEL = "appLevel";
    private static final String TAG_APP = "app";

    @Override
    public boolean accept(Node node) {
        return node.getNodeName().equals(TAG_LOG_LEVEL);
    }

    @Override
    public void parse(Node node, GlobalRule globalRuleHolder) {
        LogLevelRule logLevelRule = new LogLevelRule();
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node cNode = children.item(j);
            if (1 != cNode.getNodeType()) continue;
            if (TAG_GLOBAL_LEVEL.equals(cNode.getNodeName())) {
                String levelStr = cNode.getTextContent().trim();
                logLevelRule.setGlobalLevelStr(levelStr);
                continue;
            }
            if (TAG_IP_LEVEL.equals(cNode.getNodeName())) {
                this.parseIpLevel(cNode, logLevelRule);
                continue;
            }
            if (!TAG_APP_LEVEL.equals(cNode.getNodeName())) continue;
            this.parseAppLevel(cNode, logLevelRule);
        }
        globalRuleHolder.setLogLevelRule(logLevelRule);
    }

    public void parseIpLevel(Node node, LogLevelRule logLevelRule) {
        NodeList children = node.getChildNodes();
        String ip = null;
        String levelStr = null;
        for (int j = 0; j < children.getLength(); ++j) {
            Node cNode = children.item(j);
            if (1 != cNode.getNodeType()) continue;
            if (TAG_IP.equals(cNode.getNodeName())) {
                ip = cNode.getTextContent().trim();
                continue;
            }
            if (!TAG_LEVEL.equals(cNode.getNodeName())) continue;
            levelStr = cNode.getTextContent().trim();
        }
        if (ip != null && !ip.isEmpty() && levelStr != null && !levelStr.isEmpty()) {
            logLevelRule.addIpLevel(ip, levelStr);
        }
    }

    public void parseAppLevel(Node node, LogLevelRule logLevelRule) {
        NodeList children = node.getChildNodes();
        String app = null;
        String levelStr = null;
        for (int j = 0; j < children.getLength(); ++j) {
            Node cNode = children.item(j);
            if (1 != cNode.getNodeType()) continue;
            if (TAG_APP.equals(cNode.getNodeName())) {
                app = cNode.getTextContent().trim();
                continue;
            }
            if (!TAG_LEVEL.equals(cNode.getNodeName())) continue;
            levelStr = cNode.getTextContent().trim();
        }
        if (app != null && !app.isEmpty() && levelStr != null && !levelStr.isEmpty()) {
            logLevelRule.addAppLevel(app, levelStr);
        }
    }
}

