/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.grouping.service;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.Rule;
import com.taobao.hsf.util.StringMatcher;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GroupingRuleItem
implements Rule {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private List<String> services = null;
    private List<String> ips = null;
    private String group = null;
    private String type = "p";

    public boolean accept(String serviceUniqueName, String ip, String type) {
        boolean serviceMatched = false;
        if ("*".equals(this.getType()) || this.getType().equalsIgnoreCase(type)) {
            String servicePattern;
            Iterator<String> iterator = this.getServices().iterator();
            while (iterator.hasNext() && !(serviceMatched = Pattern.matches(servicePattern = iterator.next(), serviceUniqueName))) {
            }
            if (serviceMatched) {
                for (String ipPattern : this.getIps()) {
                    StringMatcher sm = new StringMatcher(ipPattern, false, false);
                    if (!sm.match(ip)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getGroup() {
        return this.group;
    }

    public List<String> getIps() {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        return this.ips;
    }

    @Override
    public String getName() {
        return "GroupingRuleItem";
    }

    @Override
    public String getRawRule() {
        throw new UnsupportedOperationException();
    }

    public List<String> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        return this.services;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setIps(List<String> ips) {
        this.ips = ips;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "GroupingRuleItem [group=" + this.group + ", services=" + this.services + ", ips=" + this.ips + ", type=" + this.type + "]";
    }

    @Override
    public boolean validate() {
        if (StringUtils.isBlank((String)this.group) || this.getServices().isEmpty() || this.getIps().isEmpty()) {
            LOGGER.error("", "[Grouping Rule] group cannot be empty");
            return false;
        }
        if (!("*".equals(this.type) || "p".equalsIgnoreCase(this.type) || "c".equalsIgnoreCase(this.type))) {
            LOGGER.error("", "[Grouping Rule] type must be in {p, c, *}");
            return false;
        }
        for (String servicePattern : this.getServices()) {
            try {
                Pattern.compile(servicePattern);
            }
            catch (Throwable t) {
                LOGGER.error("", "[Grouping Rule] Illegal service regex pattern: " + servicePattern);
                return false;
            }
        }
        return true;
    }
}

