/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model;

import com.ali.com.google.common.collect.Maps;
import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ConsumerServiceModel;
import com.taobao.hsf.model.ProviderMethodModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.util.PojoUtils;
import com.taobao.middleware.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApplicationModel {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final ConcurrentMap<String, ProviderServiceModel> providedServices = new ConcurrentHashMap<String, ProviderServiceModel>();
    private final ConcurrentMap<String, ConsumerServiceModel> consumedMetadatas = new ConcurrentHashMap<String, ConsumerServiceModel>();
    private final ConcurrentMap<Integer, ProviderMethodModel> providerCoders = new ConcurrentHashMap<Integer, ProviderMethodModel>();
    private volatile String revertCoders = "";
    private volatile boolean isRefresh = true;
    private volatile Object tpsRule = null;
    private final Thread loadThread = Thread.currentThread();

    private ApplicationModel() {
    }

    public static ApplicationModel instance() {
        return ApplicationModelHolder.model;
    }

    public boolean isSupportTps() {
        return this.tpsRule != null;
    }

    public void setTpsRule(Object tpsRule) {
        this.tpsRule = tpsRule;
    }

    public Object getTpsRule() {
        return this.tpsRule;
    }

    public ProviderServiceModel getProvidedServiceModel(String serviceName) {
        return (ProviderServiceModel)this.providedServices.get(serviceName);
    }

    public String getProviderRevertCoders() {
        if (this.isRefresh) {
            HashMap mapper = Maps.newHashMap();
            for (ProviderServiceModel serviceModel : this.providedServices.values()) {
                for (ProviderMethodModel methodModel : serviceModel.getAllMethods()) {
                    mapper.put(methodModel.getMethodKeyWithServiceName(), methodModel.getIndex());
                }
            }
            this.revertCoders = (String)PojoUtils.generalize(mapper);
            this.isRefresh = false;
        }
        return this.revertCoders;
    }

    public ConsumerServiceModel getConsumedServiceModel(String serviceName) {
        return (ConsumerServiceModel)this.consumedMetadatas.get(serviceName);
    }

    public Collection<ConsumerServiceModel> allConsumedServices() {
        return new ArrayList<ConsumerServiceModel>(this.consumedMetadatas.values());
    }

    public Collection<ProviderServiceModel> allProvidedServices() {
        return new ArrayList<ProviderServiceModel>(this.providedServices.values());
    }

    public boolean initConsumerService(String servicename, ConsumerServiceModel serviceModel) {
        if (Thread.currentThread() != this.loadThread) {
            LOGGER.warn("Init consumer service must be in the same thread:" + servicename + "|" + Thread.currentThread() + "|" + this.loadThread);
        }
        return this.consumedMetadatas.putIfAbsent(servicename, serviceModel) == null;
    }

    public void initProviderService(String servicename, ProviderServiceModel serviceModel) {
        if (Thread.currentThread() != this.loadThread) {
            LOGGER.warn("Init provider service must be in the same thread:" + servicename + "|" + Thread.currentThread() + "|" + this.loadThread);
        }
        if (this.providedServices.putIfAbsent(servicename, serviceModel) != null) {
            LOGGER.warn("Already register the same:" + servicename);
        } else {
            for (ProviderMethodModel methodModel : serviceModel.getAllMethods()) {
                this.providerCoders.put(methodModel.getIndex(), methodModel);
            }
            this.isRefresh = true;
        }
    }

    public EnumConfigStyle getConfigStyleOfConsumer(String serviceUniqueName) {
        return ((ConsumerServiceModel)this.consumedMetadatas.get(serviceUniqueName)).getMetadata().getConfigStyle();
    }

    private static class ApplicationModelHolder {
        public static final ApplicationModel model = new ApplicationModel();

        private ApplicationModelHolder() {
        }
    }
}

