/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.model;

import com.taobao.hsf.model.ConsumerMethodModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;

public class ConsumerServiceModel {
    private final ServiceMetadata metadata;
    private final Object proxyObject;
    private final Map<Method, ConsumerMethodModel> methodModels = new IdentityHashMap<Method, ConsumerMethodModel>();

    public ConsumerServiceModel(ServiceMetadata metadata, Object proxyObject) {
        this.metadata = metadata;
        this.proxyObject = proxyObject;
        if (proxyObject != null) {
            Class<?> proxyClass = proxyObject.getClass();
            try {
                for (Field field : proxyClass.getDeclaredFields()) {
                    field.setAccessible(true);
                    Method method = (Method)field.get(this.proxyObject);
                    this.methodModels.put(method, new ConsumerMethodModel(method, metadata));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ServiceMetadata getMetadata() {
        return this.metadata;
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public ConsumerMethodModel getMethodModel(Method method) {
        return this.methodModels.get(method);
    }
}

