/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.remoting.EnumRemotingType;
import com.taobao.hsf.remoting.util.RemotingUtil;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public final class RemotingURL {
    private static final String CONNECTIONINDEX = "&b=";
    private static final ConcurrentHashMap<String, SoftReference<RemotingURL>> parsedUrls = new ConcurrentHashMap();
    private final EnumRemotingType serverType;
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    private final Map<String, String> parameters;
    private final String url;
    private final int timeout;
    private final byte serializeType;
    private final List<MethodSpecial> methodSpecials;

    public RemotingURL(String url, String protocol, String host, int port, String path, Map<String, String> parameters) {
        this.url = url;
        this.protocol = protocol;
        this.host = host;
        this.port = port < 0 ? 0 : port;
        this.path = path;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
        this.methodSpecials = RemotingUtil.getMethodSpecials(url);
        EnumRemotingType sType = EnumRemotingType.HSF1;
        if ("2.0".equals(this.getParameter("v"))) {
            sType = EnumRemotingType.HSF2;
        }
        this.serverType = sType;
        switch (this.serverType) {
            case HSF1: {
                this.serializeType = (byte)this.getParameter("_SERIALIZETYPE", 1);
                this.timeout = this.getParameter("_TIMEOUT", 3000);
                break;
            }
            default: {
                this.serializeType = (byte)this.getParameter("_p", 1);
                this.timeout = this.getParameter("_TIMEOUT", 3000);
            }
        }
    }

    public static RemotingURL valueOf(String targetURL, int connectionIndex) {
        return RemotingURL.valueOf(targetURL + CONNECTIONINDEX + connectionIndex);
    }

    public static RemotingURL valueOf(String urlParameter) {
        if (urlParameter == null) {
            throw new IllegalArgumentException("url == null");
        }
        SoftReference<RemotingURL> remotingURL = parsedUrls.get(urlParameter);
        RemotingURL url = null;
        if (remotingURL != null) {
            url = remotingURL.get();
            if (url != null) {
                return url;
            }
            parsedUrls.remove(urlParameter);
        }
        url = RemotingURL.parseUrl(urlParameter);
        parsedUrls.put(urlParameter, new SoftReference<RemotingURL>(url));
        return url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPort(int defaultPort) {
        return this.port <= 0 ? defaultPort : this.port;
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        if (this.path != null && !this.path.startsWith("/")) {
            return "/" + this.path;
        }
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameterAndDecoded(String key) {
        return this.getParameterAndDecoded(key, null);
    }

    public String getParameterAndDecoded(String key, String defaultValue) {
        return RemotingURL.decode(this.getParameter(key, defaultValue));
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value.split(":");
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public String getMethodParameterAndDecoded(String method, String key) {
        return RemotingURL.decode(this.getMethodParameter(method, key));
    }

    public String getMethodParameterAndDecoded(String method, String key, String defaultValue) {
        return RemotingURL.decode(this.getMethodParameter(method, key, defaultValue));
    }

    public String getMethodParameter(String method, String key) {
        String value = this.parameters.get(method + "." + key);
        if (value == null || value.length() == 0) {
            return this.getParameter(key);
        }
        return value;
    }

    public String getMethodParameter(String method, String key, String defaultValue) {
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public char getMethodParameter(String method, String key, char defaultValue) {
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public boolean getMethodParameter(String method, String key, boolean defaultValue) {
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean hasMethodParameter(String method, String key) {
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        String value = this.getMethodParameter(method, key);
        return value != null && value.length() > 0;
    }

    public RemotingURL addParameterAndEncoded(String key, String value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, RemotingURL.encode(value));
    }

    public RemotingURL addParameter(String key, boolean value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, char value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, byte value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, int value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, long value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, float value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, double value) {
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, Enum<?> value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public RemotingURL addParameter(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.addParameter(key, String.valueOf(value));
    }

    public String getRawParameter(String key) {
        if ("protocol".equals(key)) {
            return this.protocol;
        }
        if ("host".equals(key)) {
            return this.host;
        }
        if ("port".equals(key)) {
            return String.valueOf(this.port);
        }
        if ("path".equals(key)) {
            return this.path;
        }
        return this.getParameter(key);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.parameters);
        if (this.protocol != null) {
            map.put("protocol", this.protocol);
        }
        if (this.host != null) {
            map.put("host", this.host);
        }
        if (this.port > 0) {
            map.put("port", String.valueOf(this.port));
        }
        if (this.path != null) {
            map.put("path", this.path);
        }
        return map;
    }

    public String toString(String ... parameters) {
        return this.buildString(false, true, parameters);
    }

    public String toIdentityString(String ... parameters) {
        return this.buildString(true, false, parameters);
    }

    public String toFullString(String ... parameters) {
        return this.buildString(true, true, parameters);
    }

    public String toParameterString(String ... parameters) {
        StringBuilder buf = new StringBuilder();
        this.buildParameters(buf, false, parameters);
        return buf.toString();
    }

    private void buildParameters(StringBuilder buf, boolean concat, String[] parameters) {
        if (this.getParameters() != null && this.getParameters().size() > 0) {
            List<String> includes = parameters == null || parameters.length == 0 ? null : Arrays.asList(parameters);
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
                if (entry.getKey() == null || entry.getKey().length() <= 0 || includes != null && !includes.contains(entry.getKey())) continue;
                if (first) {
                    if (concat) {
                        buf.append("?");
                    }
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(entry.getKey());
                buf.append("=");
                buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
    }

    private String buildString(boolean appendUser, boolean appendParameter, String ... parameters) {
        return this.buildString(appendUser, appendParameter, false, false, parameters);
    }

    private String buildString(boolean appendUser, boolean appendParameter, boolean useIP, boolean useService, String ... parameters) {
        String path;
        String host;
        StringBuilder buf = new StringBuilder();
        if (this.protocol != null && this.protocol.length() > 0) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if ((host = this.getHost()) != null && host.length() > 0) {
            buf.append(host);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if ((path = useService ? this.getServiceKey() : this.getPath()) != null && path.length() > 0) {
            buf.append("/");
            buf.append(path);
        }
        if (appendParameter) {
            this.buildParameters(buf, true, parameters);
        }
        return buf.toString();
    }

    public String getServiceKey() {
        String inf = this.getParameter("interface");
        if (inf == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String group = this.getParameter("group");
        if (group != null && group.length() > 0) {
            buf.append(group).append("/");
        }
        buf.append(inf);
        String version = this.getParameter("version");
        if (version != null && version.length() > 0) {
            buf.append(":").append(version);
        }
        return buf.toString();
    }

    public URL toJavaURL() {
        try {
            return new URL(this.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String toServiceString() {
        return this.buildString(true, false, true, true, new String[0]);
    }

    public static String encode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static RemotingURL parseUrl(String urlParameter) {
        String fullUrl = urlParameter;
        String url = urlParameter;
        String protocol = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = url.indexOf("?");
        if (i >= 0) {
            String[] parts;
            for (String part : parts = url.substring(i + 1).split("\\&")) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(part.substring(0, j), part.substring(j + 1));
                    continue;
                }
                parameters.put(part, part);
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("url missing protocol: \"" + url + "\"");
            }
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else {
            i = url.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("url missing protocol: \"" + url + "\"");
                }
                protocol = url.substring(0, i);
                url = url.substring(i + 1);
            }
        }
        i = url.indexOf("/");
        if (i >= 0) {
            path = url.substring(i + 1);
            url = url.substring(0, i);
        }
        if ((i = url.indexOf(":")) >= 0 && i < url.length() - 1) {
            port = Integer.parseInt(url.substring(i + 1));
            url = url.substring(0, i);
        }
        if (url.length() > 0) {
            host = url;
        }
        return new RemotingURL(fullUrl, protocol, host, port, path, parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemotingURL other = (RemotingURL)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public int getParameter(String parameterName, int defaultValue) {
        String stringValue = this.getParameter(parameterName);
        if (StringUtils.isBlank((String)stringValue)) {
            return defaultValue;
        }
        return Integer.valueOf(stringValue);
    }

    public String toString() {
        return this.url;
    }

    public EnumRemotingType getServerType() {
        return this.serverType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public byte getSerializeType() {
        return this.serializeType;
    }

    public List<MethodSpecial> getMethodSpecials() {
        return this.methodSpecials;
    }
}

