/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.remoting.Remoting;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.DefaultSerialization;
import com.taobao.remoting.serialize.SerializationUtil;
import com.taobao.remoting.serialize.impl.DeserializeException;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TbRemotingResponse
extends BaseResponse {
    private static final String UNKNOWN_TB_REMOTING_RESPONSE = "unknown tb remoting response:";
    private static final String DESERIALIZATION_RESPOSNE_ERROR = "deserialization resposne error on client side:";
    private static final CustomSerialization<Object> defaultSerialize = new DefaultSerialization();
    private final InputStream is;
    private final byte codecType;
    private final int appTypeLen;
    private final ConnectionResponse connectionResponse;
    private final SliceOutputStream sliceOs;
    private final String errorMsgOnClient;
    private final int size;

    public TbRemotingResponse(InputStream is, byte codecType, ConnectionResponse connectionResponse, int appTypeLen, int size) {
        super(13, connectionResponse.getRequestId());
        this.is = is;
        this.size = size;
        this.connectionResponse = connectionResponse;
        this.codecType = codecType;
        this.appTypeLen = appTypeLen;
        this.sliceOs = null;
        this.errorMsgOnClient = null;
    }

    public TbRemotingResponse(SliceOutputStream sliceOs) {
        super(13, 0L);
        this.is = null;
        this.connectionResponse = null;
        this.codecType = 1;
        this.sliceOs = sliceOs;
        this.size = sliceOs.size();
        this.errorMsgOnClient = null;
        this.appTypeLen = 0;
    }

    public TbRemotingResponse(String errorMsg) {
        super(13, 0L);
        this.is = null;
        this.size = 0;
        this.connectionResponse = null;
        this.codecType = 1;
        this.appTypeLen = 0;
        this.sliceOs = null;
        this.errorMsgOnClient = errorMsg;
    }

    public SliceOutputStream getSliceOs() {
        if (this.sliceOs == null) {
            throw new IllegalStateException("should never come here");
        }
        return this.sliceOs;
    }

    @Override
    public HSFResponse getResponseObject(BaseRequest request) {
        if (this.errorMsgOnClient != null) {
            return this.createClientErrorHSFResponse(this.errorMsgOnClient);
        }
        Object appResponse = null;
        try {
            if (0 == this.appTypeLen) {
                return this.createClientErrorHSFResponse("deserialization resposne error on client side: appTypeLen error");
            }
            byte[] tmp = new byte[this.appTypeLen];
            this.is.read(tmp);
            String appType = new String(tmp);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            appResponse = this.getSerial(appType).deserialize(this.is, this.codecType);
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (DeserializeException ioe) {
            ConnectionResponse response = ioe.getResponse();
            if (response != null) {
                return this.createClientErrorHSFResponse(DESERIALIZATION_RESPOSNE_ERROR + ioe.getMessage());
            }
            return this.createClientErrorHSFResponse(UNKNOWN_TB_REMOTING_RESPONSE + ioe.getMessage());
        }
        catch (IOException e) {
            return this.createClientErrorHSFResponse(DESERIALIZATION_RESPOSNE_ERROR + e.getMessage());
        }
        int errorCode = this.connectionResponse.getResult();
        if (errorCode == 0) {
            if (appResponse instanceof HSFResponse) {
                return (HSFResponse)appResponse;
            }
            return this.createClientErrorHSFResponse(UNKNOWN_TB_REMOTING_RESPONSE);
        }
        return this.createClientErrorHSFResponse(this.connectionResponse.getErrorMsg());
    }

    private HSFResponse createClientErrorHSFResponse(String msg) {
        HSFResponse hsfReponse = new HSFResponse();
        hsfReponse.setClientErrorMsg(msg);
        return hsfReponse;
    }

    private CustomSerialization<Object> getSerial(String type) {
        Remoting.serialUtil();
        CustomSerialization<Object> result = SerializationUtil.getCustom((String)type);
        if (null == result) {
            result = defaultSerialize;
        }
        return result;
    }

    @Override
    public void encode(ByteBufferWrapper bytebufferWrapper) throws Exception {
        SliceOutputStream os = this.getSliceOs();
        bytebufferWrapper.ensureCapacity(os.size());
        for (byte[] slice : os.allSlices()) {
            bytebufferWrapper.writeBytes(slice);
        }
    }

    @Override
    public int size() {
        return this.size;
    }
}

