/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.client;

import com.ali.com.google.common.cache.Cache;
import com.ali.com.google.common.cache.CacheBuilder;
import com.ali.com.google.common.cache.RemovalListener;
import com.ali.com.google.common.cache.RemovalNotification;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.ClientFactory;
import com.taobao.hsf.remoting.exception.RemotingCheckedException;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class AbstractClientFactory
implements ClientFactory {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final Cache<RemotingURL, Client> cacherClients = CacheBuilder.newBuilder().maximumSize(262144L).expireAfterAccess(27L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<RemotingURL, Client>(){

        public void onRemoval(RemovalNotification<RemotingURL, Client> notification) {
            if (((Client)notification.getValue()).isConnected()) {
                ((Client)notification.getValue()).close("[Remoting] removed from cache");
            }
        }
    }).build();

    @Override
    public Client get(final RemotingURL url) throws Exception {
        Client client = (Client)this.cacherClients.get((Object)url, (Callable)new Callable<Client>(){

            @Override
            public Client call() throws Exception {
                Client client = AbstractClientFactory.this.createClient(url);
                if (client != null) {
                    client.startHeartBeat();
                }
                return client;
            }
        });
        if (client == null || !client.isConnected()) {
            this.cacherClients.invalidate((Object)url);
            return null;
        }
        if (client.isEnabled()) {
            return client;
        }
        return null;
    }

    @Override
    public List<Client> retrieveAllClient() throws Exception {
        ArrayList<Client> result = new ArrayList<Client>((int)this.cacherClients.size());
        result.addAll(this.cacherClients.asMap().values());
        return result;
    }

    public List<RemotingURL> retrieveAllClientKeys() throws Exception {
        ArrayList<RemotingURL> result = new ArrayList<RemotingURL>((int)this.cacherClients.size());
        result.addAll(this.cacherClients.asMap().keySet());
        return result;
    }

    public static ClientFactory getInstance() {
        throw new UnsupportedOperationException("should be implemented by sub class");
    }

    protected abstract Client createClient(RemotingURL var1) throws RemotingCheckedException;

    @Override
    public void remove(Client client) {
        if (client != null) {
            this.cacherClients.invalidate((Object)client.getUrl());
            LOGGER.warn(MessageFormat.format("[Remoting] {0} is removed", client));
        }
    }
}

