/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.client;

import com.taobao.eagleeye.EagleEye;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.client.BaseRequestWrapperInterface;
import com.taobao.hsf.remoting.client.HeartbeatListner;
import com.taobao.hsf.remoting.client.SendCallBackListener;
import java.util.concurrent.Executor;

public class RequestWrapperOfCallback
implements BaseRequestWrapperInterface {
    private final long startTime = System.currentTimeMillis();
    private final SendCallBackListener listener;
    private final BaseRequest request;

    public RequestWrapperOfCallback(BaseRequest request, SendCallBackListener listener) {
        this.listener = listener;
        this.request = request;
    }

    public SendCallBackListener getListener() {
        return this.listener;
    }

    @Override
    public BaseRequest getRequest() {
        return this.request;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void onResponse(final BaseResponse response) {
        if (this.listener instanceof HeartbeatListner) {
            this.listener.onResponse(new HSFResponse());
        } else {
            Executor executor = this.listener.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        EagleEye.responseSize((long)response.size());
                        RequestWrapperOfCallback.this.listener.onResponse(response.getResponseObject(RequestWrapperOfCallback.this.request));
                    }
                });
            } else {
                this.listener.onResponse(response.getResponseObject(this.request));
            }
        }
    }

    @Override
    public void removeAllRequestCallBackWhenClose() {
        HSFResponse response = new HSFResponse();
        response.setClientErrorMsg("invalid call is removed because of connection closed");
        this.getListener().onResponse(response);
    }

    @Override
    public void cleanupInvalidCallBack() {
        HSFResponse response = new HSFResponse();
        response.setClientErrorMsg("invalid call because of timeout:" + this.request.getTimeout());
        this.getListener().onResponse(response);
    }
}

