/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.exception;

import com.taobao.hsf.remoting.exception.ErrorCode;
import com.taobao.hsf.remoting.exception.ErrorCodeDataSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class LocalDataSource
implements ErrorCodeDataSource {
    private final Map<Integer, ErrorCode> errorCodes = new HashMap<Integer, ErrorCode>();

    public LocalDataSource() throws Exception {
        this.loadPropertiesResource("errorcode.properties");
    }

    @Override
    public ErrorCode getCode(int key) {
        return this.errorCodes.get(key);
    }

    @Override
    public List<ErrorCode> getCodes() {
        return new ArrayList<ErrorCode>(this.errorCodes.values());
    }

    @Override
    public int size() {
        return this.errorCodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPropertiesResource(String propertiesResource) throws Exception {
        InputStream reader = LocalDataSource.class.getClassLoader().getResourceAsStream(propertiesResource);
        try {
            if (reader == null) {
                throw new Exception("unable to load error codes from empty input stream: [" + propertiesResource + "]");
            }
            Properties properties = new Properties();
            properties.load(reader);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                ErrorCode code = new ErrorCode();
                code.setCode(Integer.valueOf((String)entry.getKey()));
                code.setMessage((String)entry.getValue());
                this.errorCodes.put(code.getCode(), code);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return true;
    }
}

