/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.invoke.component;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.NamedThreadFactory;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.SendCallBackListener;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.hsf.remoting.service.InvokeService;
import com.taobao.hsf.tbremoting.invoke.CallbackInvocationContext;
import com.taobao.hsf.tbremoting.invoke.HSFResponseCallback;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.ReflectUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class CallbackInvokeComponent
implements InvokeService {
    public static final String INVOKE_REMOTE_CALLBACK = "CALLBACK";
    private static final LogService logService = HSFServiceContainer.getInstance(LogService.class);

    @Override
    public String getKey() {
        return INVOKE_REMOTE_CALLBACK;
    }

    @Override
    public Object invoke(HSFRequest request, ServiceMetadata metadata, RemotingURL remotingURL, byte codecType, int timeout, String methodName) throws HSFException {
        ServiceMetadata.AsyncallMethod funcDesc = metadata.getAsyncallMethod(methodName);
        try {
            Client client = NettyClientFactory.getInstance().get(remotingURL);
            Object context = logService.getRpcContext();
            logService.beforeInvoke();
            if (metadata.getConfigStyle() == EnumConfigStyle.HSF) {
                Object obj;
                HSFResponseCallback bizCallback = (HSFResponseCallback)funcDesc.getCallbackInstance();
                if (bizCallback == null && (obj = metadata.getCallbackInvoker()) instanceof HSFResponseCallback) {
                    bizCallback = (HSFResponseCallback)obj;
                }
                client.invokeWithCallBack(request, new HSFCallBackListener(bizCallback, context, CallbackInvocationContext.getContext()), timeout, codecType);
            }
        }
        catch (Exception e) {
            throw new HSFException("", e);
        }
        if (funcDesc.getMethod() == null) {
            return null;
        }
        return ReflectUtils.defaultReturn(funcDesc.getMethod());
    }

    private static class CallExecutorResourceHolder {
        public static final Executor callBackExcecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("HSF-CallBack"));

        private CallExecutorResourceHolder() {
        }
    }

    public static final class HSFCallBackListener
    implements SendCallBackListener {
        private final HSFResponseCallback hsfCallback;
        private final Object context;
        private final Object bizObject;

        public HSFCallBackListener(HSFResponseCallback _callback, Object context, Object obj) {
            this.hsfCallback = _callback;
            this.context = context;
            this.bizObject = obj;
        }

        @Override
        public void onResponse(HSFResponse hsfResp) {
            Object appResp = hsfResp.getAppResponse();
            CallbackInvocationContext.setContext(this.bizObject);
            logService.setRpcContext(this.context);
            try {
                if (hsfResp.isError()) {
                    logService.hsfError();
                    this.hsfCallback.onHSFException(new HSFException(hsfResp.getErrorMsg(), hsfResp.getErrorMsg()));
                } else if (appResp instanceof Throwable) {
                    logService.businessError();
                    this.hsfCallback.onAppException((Throwable)appResp);
                } else {
                    logService.success();
                    this.hsfCallback.onAppResponse(appResp);
                }
            }
            finally {
                CallbackInvocationContext.setContext(null);
            }
        }

        @Override
        public Executor getExecutor() {
            return CallExecutorResourceHolder.callBackExcecutor;
        }
    }
}

