/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.invoke.component;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.hsf.remoting.service.InvokeService;
import com.taobao.hsf.tbremoting.invoke.HSFResponseFuture;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.ReflectUtils;
import java.util.concurrent.Future;

public class FutureInvokeComponent
implements InvokeService {
    private static final String INVOKE_REMOTE_FUTURE = "FUTURE";
    private static final LogService logService = HSFServiceContainer.getInstance(LogService.class);

    @Override
    public String getKey() {
        return INVOKE_REMOTE_FUTURE;
    }

    @Override
    public Object invoke(HSFRequest request, ServiceMetadata metadata, RemotingURL remotingURL, byte codecType, int timeout, String methodName) throws HSFException {
        try {
            Client client = NettyClientFactory.getInstance().get(remotingURL);
            Future<Object> future = client.futureInvoke(request, codecType, timeout);
            if (metadata.getConfigStyle() == EnumConfigStyle.HSF) {
                HSFResponseFuture.setFuture(future);
            }
        }
        catch (Exception e) {
            throw new HSFException("eror on submit request on future invoke:", e);
        }
        logService.rpcClientSend();
        if (request.getReturnClass() == null) {
            return null;
        }
        return ReflectUtils.defaultReturn(request.getReturnClass());
    }
}

