/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.invoke.component;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFTimeOutException;
import com.taobao.hsf.log.LogService;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.ClientFactory;
import com.taobao.hsf.remoting.exception.RemotingUncheckedException;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.hsf.remoting.service.InvokeService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SyncInvokeComponent
implements InvokeService {
    private final ClientFactory clientFactory = NettyClientFactory.getInstance();
    private final LogService logService = HSFServiceContainer.getInstance(LogService.class);

    @Override
    public String getKey() {
        return "SYNC";
    }

    @Override
    public Object invoke(HSFRequest request, ServiceMetadata metadata, RemotingURL remotingURL, byte codecType, int timeout, String methodName) throws HSFException {
        HSFResponse hsfResp;
        try {
            Client client = this.clientFactory.get(remotingURL);
            Future<Object> future = client.futureInvoke(request, codecType, timeout);
            this.logService.rpcClientSend();
            hsfResp = (HSFResponse)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(new HSFTimeOutException(this.getErrorLog(e.getMessage()), e));
        }
        catch (TimeoutException e) {
            throw new RuntimeException(new HSFTimeOutException(this.getErrorLog(e.getMessage()), timeout + "", e));
        }
        catch (RemotingUncheckedException e) {
            if (e.getErrorCode().getCode() == 103) {
                throw new RuntimeException(new HSFTimeOutException(this.getErrorLog(e.getMessage()), timeout + "", e));
            }
            throw new RuntimeException(new HSFException("", e));
        }
        catch (Exception e) {
            throw new RuntimeException(new HSFException("", e));
        }
        if (hsfResp.isError()) {
            throw new RuntimeException(new HSFException(hsfResp.getErrorMsg(), hsfResp.getErrorMsg()));
        }
        return hsfResp.getAppResponse();
    }

    private String getErrorLog(String cause) {
        return LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0002", (String)"Biz-Problem", (String)cause);
    }
}

