/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.BaseResponse;
import com.taobao.hsf.remoting.Connection;
import com.taobao.middleware.logger.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;

public class NettyConnection
implements Connection {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final Channel channel;
    private final String peerIP;
    private volatile long lastReadTime = System.currentTimeMillis();

    public NettyConnection(Channel channel) {
        this.channel = channel;
        this.peerIP = ((InetSocketAddress)channel.remoteAddress()).getAddress().getHostAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    @Override
    public String getPeerIP() {
        return this.peerIP;
    }

    @Override
    public void writeReponseToChannel(final BaseResponse response) {
        if (response != null && this.channel.isWritable()) {
            ChannelFuture wf = this.channel.writeAndFlush((Object)response);
            wf.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOGGER.error("", "##########server write response error,request id is: " + response.getRequestID());
                        if (!NettyConnection.this.channel.isActive()) {
                            NettyConnection.this.channel.close();
                        }
                    }
                }
            });
        }
    }

    public String toString() {
        return MessageFormat.format("L:{0},R:{1}", this.getLocalAddress(), this.getRemoteAddress());
    }

    @Override
    public void refreshLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public void setLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

