/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.client;

import com.taobao.eagleeye.EagleEye;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.RemotingRuntimeInfoHolder;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.client.AbstractClient;
import com.taobao.hsf.remoting.client.ClientFactory;
import com.taobao.hsf.remoting.client.HeartbeatListner;
import com.taobao.hsf.remoting.client.RequestOfCleanInvalidCallback;
import com.taobao.hsf.remoting.client.RequestWrapperOfCallback;
import com.taobao.hsf.remoting.client.RequestWrapperOfFuture;
import com.taobao.hsf.remoting.client.SendCallBackListener;
import com.taobao.hsf.remoting.exception.RemotingCheckedException;
import com.taobao.hsf.remoting.netty.NettySharedHolder;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.locale.LogResources;
import io.netty.channel.Channel;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class NettyClient
extends AbstractClient {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final Channel channel;
    private int hbTimes = 0;

    public NettyClient(RemotingURL url, Channel channel) {
        super(url);
        this.channel = channel;
    }

    @Override
    public void sendRequest(BaseRequest request, RequestWrapperOfFuture future) throws RemotingCheckedException {
        EagleEye.requestSize((long)request.size());
        this.channel.writeAndFlush((Object)future);
        RemotingRuntimeInfoHolder.getInstance().increasecountSendRequests();
    }

    @Override
    public void sendRequest(BaseRequest request, SendCallBackListener listener) throws Exception {
        EagleEye.requestSize((long)request.size());
        this.channel.writeAndFlush((Object)new RequestWrapperOfCallback(request, listener));
        RemotingRuntimeInfoHolder.getInstance().increasecountSendRequests();
    }

    @Override
    public void startHeartBeat() throws Exception {
        final BaseRequest hbRequest = this.getServerType().generateHBRequest(this);
        NettySharedHolder.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                try {
                    NettyClient.this.sendRequest(hbRequest, new HeartbeatListner(NettyClient.this));
                }
                catch (Throwable t) {
                    LOGGER.error("", "[remoting] HB error", t);
                }
                finally {
                    if (NettyClient.this.isEnabled()) {
                        NettySharedHolder.timer.newTimeout((TimerTask)this, 27L, TimeUnit.SECONDS);
                    }
                }
            }
        }, 27L, TimeUnit.SECONDS);
    }

    @Override
    public String getServerIP() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getHostName();
    }

    @Override
    public int getServerPort() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getPort();
    }

    @Override
    public int inceaseAndGetHbTimes() {
        return ++this.hbTimes;
    }

    @Override
    public void resetHbTimes() {
        this.hbTimes = 0;
    }

    @Override
    public ClientFactory getClientFactory() {
        return NettyClientFactory.getInstance();
    }

    @Override
    public void doClose(String cause) {
        if (!StringUtils.isBlank((String)cause) && !"null".equals(cause.trim())) {
            LOGGER.info(LogResources.getLog((String)"initCloseConnection", (Object[])new Object[]{this, cause}));
        } else {
            LOGGER.info(LogResources.getLog((String)"initCloseConnection", (Object[])new Object[]{this, cause}), new Object[]{new Exception()});
        }
        this.channel.close();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("serverType:");
        sb.append((Object)this.getServerType()).append(",").append(this.channel);
        return sb.toString();
    }

    @Override
    public boolean isEnabled() {
        return this.channel.isWritable() && this.enable;
    }

    @Override
    public boolean isConnected() {
        return this.channel.isActive();
    }

    @Override
    public void removeAllInvalidRequestCallBack(long now) {
        this.channel.writeAndFlush((Object)new RequestOfCleanInvalidCallback(now));
    }
}

