/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.client;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.client.Client;
import com.taobao.hsf.remoting.client.ScanTask;
import com.taobao.hsf.remoting.netty.NettySharedHolder;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.middleware.logger.Logger;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ScanAllClientRunnerClientSide
implements TimerTask {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private final List<ScanTask> taskList = new ArrayList<ScanTask>();
    private final NettyClientFactory clientFactory;

    public ScanAllClientRunnerClientSide(NettyClientFactory clientFactory, ScanTask ... tasks) {
        this.clientFactory = clientFactory;
        if (tasks != null) {
            for (ScanTask task : tasks) {
                this.taskList.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) throws Exception {
        long now = System.currentTimeMillis();
        try {
            List<Client> connections = this.clientFactory.retrieveAllClient();
            if (connections != null) {
                for (Client conn : connections) {
                    for (ScanTask task : this.taskList) {
                        task.visit(now, conn);
                    }
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("", "error during scanALLClients on client side:", e);
        }
        finally {
            NettySharedHolder.timer.newTimeout((TimerTask)this, 60L, TimeUnit.SECONDS);
        }
    }
}

