/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.server;

import com.alibaba.fastjson.JSON;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.server.output.ServerOutput;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

public class HttpOutput
extends ServerOutput {
    private static final String TEXT_PLAIN = "text/plain";
    private final ChannelHandlerContext ctx;
    private final HttpRequest httpRequest;

    public HttpOutput(Connection connection, ChannelHandlerContext ctx, HttpRequest httpRequest, long startTime) {
        super(connection, startTime);
        this.ctx = ctx;
        this.httpRequest = httpRequest;
    }

    @Override
    public int writeHSFResponse(HSFResponse hsfResponse) {
        DefaultFullHttpResponse response = null;
        if (hsfResponse.isError()) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])hsfResponse.getErrorMsg().getBytes()));
            response.headers().set("Content-Type", (Object)TEXT_PLAIN);
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])JSON.toJSONString((Object)hsfResponse).getBytes()));
            response.headers().set("Content-Type", (Object)TEXT_PLAIN);
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)this.httpRequest)) {
            this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set("Connection", (Object)"keep-alive");
            this.ctx.writeAndFlush((Object)response);
        }
        return response.content().readableBytes();
    }
}

