/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.netty.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.netty.NettyConnection;
import com.taobao.hsf.remoting.netty.server.HttpOutput;
import com.taobao.hsf.remoting.pool.ThreadPoolManager;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.middleware.logger.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URLDecoder;

public class NettyServerHttpHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String TEXT_PLAIN = "text/plain";
    private static final byte[] ERROR_CONTENT = "Request format is wrong.".getBytes();
    private final RpcRequestProcessor rpcRequestProcessor;
    private final ThreadPoolManager threadPoolManager;

    public NettyServerHttpHandler(RpcRequestProcessor rpcRequestProcessor) {
        this.rpcRequestProcessor = rpcRequestProcessor;
        this.threadPoolManager = rpcRequestProcessor.getThreadPoolManager();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            String[] pathArray;
            final HttpRequest httpRequest = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)httpRequest)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            if ((pathArray = httpRequest.getUri().split("/")) != null && pathArray.length > 2) {
                this.threadPoolManager.getThreadExecutor(pathArray[1]).execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NettyServerHttpHandler.this.processOneHttpRequest(ctx, httpRequest, pathArray, System.currentTimeMillis());
                        }
                        catch (Throwable e) {
                            LOGGER.error("", "[Remoting]", e);
                        }
                    }
                });
            } else {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])ERROR_CONTENT));
                response.headers().set("Content-Type", (Object)TEXT_PLAIN);
                response.headers().set("Content-Length", (Object)response.content().readableBytes());
                this.writeResponse(ctx, httpRequest, (FullHttpResponse)response);
            }
        } else {
            LOGGER.error("", "should be unreached!");
        }
    }

    private void processOneHttpRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, String[] pathArray, long startTime) throws Exception {
        HSFRequest hsfRequest = new HSFRequest();
        hsfRequest.setTargetServiceUniqueName(pathArray[1]);
        hsfRequest.setMethodName(pathArray[2]);
        if (pathArray.length == 5) {
            String[] argsTypes = (String[])JSON.parseObject((String)URLDecoder.decode(pathArray[3], "utf-8"), String[].class);
            Object[] args = new Object[argsTypes.length];
            String[] argsOfString = (String[])JSON.parseObject((String)URLDecoder.decode(pathArray[4], "utf-8"), String[].class);
            for (int i = 0; i < argsTypes.length; ++i) {
                args[i] = JSON.parseObject((String)argsOfString[i], Class.forName(argsTypes[i]));
            }
            hsfRequest.setMethodArgSigs(argsTypes);
            hsfRequest.setMethodArgs(args);
        } else if (pathArray.length == 4) {
            String[] argsTypes = (String[])JSON.parseObject((String)URLDecoder.decode(pathArray[3], "utf-8"), String[].class);
            Object[] args = new Object[argsTypes.length];
            ByteBuf contentByteBuf = ((DefaultFullHttpRequest)httpRequest).content();
            int length = contentByteBuf.readableBytes();
            byte[] content = new byte[length];
            contentByteBuf.readBytes(content);
            String[] argsOfString = (String[])JSON.parseObject((byte[])content, String[].class, (Feature[])new Feature[0]);
            for (int i = 0; i < argsTypes.length; ++i) {
                args[i] = JSON.parseObject((String)argsOfString[i], Class.forName(argsTypes[i]));
            }
            hsfRequest.setMethodArgSigs(argsTypes);
            hsfRequest.setMethodArgs(args);
        } else {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])ERROR_CONTENT));
            response.headers().set("Content-Type", (Object)TEXT_PLAIN);
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            this.writeResponse(ctx, httpRequest, (FullHttpResponse)response);
            return;
        }
        this.rpcRequestProcessor.handleRequest(hsfRequest, new HttpOutput(new NettyConnection(ctx.channel()), ctx, httpRequest, startTime));
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest httpRequest, FullHttpResponse response) {
        if (!HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set("Connection", (Object)"keep-alive");
            ctx.writeAndFlush((Object)response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error("", "[Remoting]", cause);
        ctx.close();
    }
}

