/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.protocol;

import com.taobao.hsf.remoting.TbRemotingRequest;
import com.taobao.hsf.remoting.TbRemotingResponse;
import com.taobao.hsf.remoting.protocol.ByteBufferWrapper;
import com.taobao.hsf.remoting.protocol.Protocol;
import com.taobao.hsf.remoting.serialize.UnsafeByteArrayInputStream;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.DefaultSerialization;
import java.io.InputStream;

public class TbRemotingProtocol
implements Protocol {
    private static final CustomSerialization<Object> defaultSerialize = new DefaultSerialization();

    @Override
    public Object decode(ByteBufferWrapper wrapper, int originPos) throws Exception {
        if (wrapper.readableBytes() < 14) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        byte requestFlag = wrapper.readByte();
        byte protocol = wrapper.readByte();
        wrapper.readByte();
        wrapper.readByte();
        int conLength = wrapper.readInt();
        byte appClassNameLength = wrapper.readByte();
        int appLength = wrapper.readInt();
        int expectedBodyLength = conLength + appClassNameLength + appLength;
        if (wrapper.readableBytes() < expectedBodyLength) {
            wrapper.setReaderIndex(originPos);
            return null;
        }
        if (0 == requestFlag) {
            byte[] body = new byte[14 + expectedBodyLength];
            wrapper.setReaderIndex(originPos);
            wrapper.readBytes(body);
            return new TbRemotingRequest(new UnsafeByteArrayInputStream(body), protocol, expectedBodyLength);
        }
        byte[] body = new byte[expectedBodyLength];
        wrapper.readBytes(body);
        ConnectionResponse response = (ConnectionResponse)defaultSerialize.deserialize((InputStream)new UnsafeByteArrayInputStream(body, 0, conLength), protocol);
        return new TbRemotingResponse(new UnsafeByteArrayInputStream(body, conLength, body.length - conLength), protocol, response, appClassNameLength, expectedBodyLength);
    }
}

