/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.provider;

import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.remoting.netty.server.NettyServer;
import com.taobao.hsf.remoting.pool.ThreadPoolManager;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.Server;
import com.taobao.hsf.remoting.service.ProviderServer;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.middleware.logger.Logger;

public class HSFProviderServer
implements ProviderServer {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String LINESEPARATOR = System.getProperty("line.separator");
    private static final String LINE = "------------------------------------";
    private final ConfigurationService configService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private final RpcRequestProcessor processor = HSFServiceContainer.getInstance(RpcRequestProcessor.class);
    private final Server server = new NettyServer(this.processor, this.configService.getServerIp());
    private final ThreadPoolManager threadPoolManager = this.processor.getThreadPoolManager();

    @Override
    public void addMetadata(String serviceUniqueName, ServiceMetadata metadata, Object workerPOJO) {
        ApplicationModel.instance().initProviderService(serviceUniqueName, new ProviderServiceModel(serviceUniqueName, metadata, workerPOJO));
    }

    @Override
    public void allocThreadPool(String serviceUniqueName, int corePoolSize, int maxPoolSize) throws HSFException {
        this.threadPoolManager.allocThreadpool(serviceUniqueName, corePoolSize, maxPoolSize);
    }

    @Override
    public void signalClosingServer() {
        this.server.signalClosingServer();
    }

    @Override
    public void closeConnections() {
        this.server.closeConnections();
    }

    @Override
    public synchronized void startHSFServer() throws HSFException {
        try {
            this.server.start(this.configService.getHSFServerPort());
            if (this.configService.isHttpEnable()) {
                this.server.startHttp(this.configService.getHttpServerPort());
            }
        }
        catch (Exception e) {
            throw new HSFException("\u542f\u52a8HSF\u670d\u52a1\u5668\u7aef\u9519\u8bef", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LINE).append(LINESEPARATOR);
        sb.append(" HSF\u670d\u52a1\u5668\u5df2\u542f\u52a8: " + this.configService.getHSFServerPort()).append(LINESEPARATOR);
        sb.append(LINE).append(LINESEPARATOR);
        sb.append(" I/O\u7ebf\u7a0b\u6570     : " + (Runtime.getRuntime().availableProcessors() + 1)).append(LINESEPARATOR);
        sb.append(" \u5904\u7406\u6700\u5c0f\u7ebf\u7a0b\u6570 : " + this.configService.getHSFServerMinPoolSize()).append(LINESEPARATOR);
        sb.append(" \u5904\u7406\u6700\u5927\u7ebf\u7a0b\u6570 : " + this.configService.getHSFServerMaxPoolSize()).append(LINESEPARATOR);
        sb.append(LINE);
        LOGGER.warn(sb.toString());
    }

    @Override
    public void stopHSFServer() throws Exception {
        this.server.stop();
    }
}

