/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.rt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AlivedFileOutputStream
extends OutputStream {
    private final File file;
    private OutputStream os;
    private Throwable ext;

    public AlivedFileOutputStream(File file) {
        if (null == file) {
            throw new NullPointerException("file");
        }
        this.file = file;
    }

    private boolean checkIO() {
        return null == this.file || this.os == null || null != this.ext;
    }

    private void openIO() throws IOException {
        this.closeIO();
        if (this.isParentDirectoryCreationRequired(this.file)) {
            this.createMissingParentDirectories(this.file);
        }
        FileOutputStream fos = new FileOutputStream(this.file, true);
        this.os = new BufferedOutputStream(fos);
        this.ext = null;
    }

    private void closeIO() throws IOException {
        if (null != this.os) {
            try {
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isParentDirectoryCreationRequired(File file) {
        File parent = file.getParentFile();
        return parent != null && !parent.exists();
    }

    private boolean createMissingParentDirectories(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            throw new IllegalStateException(file + " should not have a null parent");
        }
        if (parent.exists()) {
            throw new IllegalStateException(file + " should not have existing parent directory");
        }
        return parent.mkdirs();
    }

    @Override
    public void write(int b) throws IOException {
        try {
            if (this.checkIO()) {
                this.openIO();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            this.ext = e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.os.flush();
        }
        catch (Exception e) {
            this.ext = e;
        }
    }
}

