/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.rt;

import com.taobao.hsf.NamedThreadFactory;
import com.taobao.hsf.address.AddressService;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.util.HSFServiceContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RTCalculator {
    private final ConfigurationService configService = HSFServiceContainer.getInstance(ConfigurationService.class);
    private final AddressService addressService = HSFServiceContainer.getInstance(AddressService.class);
    private final ExecutorService rtLoop = Executors.newSingleThreadExecutor(new NamedThreadFactory("HSF-RTCalculator"));
    private static final ThreadLocal<RTLocal> RT_LOCAL = new ThreadLocal<RTLocal>(){

        @Override
        protected RTLocal initialValue() {
            return new RTLocal();
        }
    };
    private final HashMap<String, HashMap<String, ConcurrentRTProfile>> serviceRtMap = new HashMap();
    private final HashMap<String, AtomicInteger> serviceInvokeCountMap = new HashMap();
    private final ConcurrentHashMap<String, ConcurrentRTProfile> pureRTMap = new ConcurrentHashMap();

    private RTCalculator() {
    }

    public static RTCalculator getInstance() {
        return InstanceHolder.i;
    }

    public int getServiceInvokeCount(String serviceUniqueName) {
        AtomicInteger count = this.serviceInvokeCountMap.get(serviceUniqueName);
        return null == count ? RT_LOCAL.get().countAddr : count.get() + RT_LOCAL.get().countAddr;
    }

    public int getRemoteIpInvokeCount(String serviceUniqueName, String remoteIp) {
        ConcurrentRTProfile profile;
        HashMap<String, ConcurrentRTProfile> remoteIp2Profile;
        ThreadlocalRTProfile threadlocalRTProfile;
        int ret = 0;
        HashMap threadlocalRTProfileHashMap = (HashMap)RT_LOCAL.get().localMap.get(serviceUniqueName);
        if (null != threadlocalRTProfileHashMap && null != (threadlocalRTProfile = (ThreadlocalRTProfile)threadlocalRTProfileHashMap.get(remoteIp))) {
            ret += threadlocalRTProfile.getCount();
        }
        if (null != (remoteIp2Profile = this.serviceRtMap.get(serviceUniqueName)) && null != (profile = remoteIp2Profile.get(remoteIp))) {
            ret += profile.getCount();
        }
        return ret;
    }

    public HashMap<String, ConcurrentRTProfile> dumpClientRtData() {
        HashMap<String, ConcurrentRTProfile> metaData = new HashMap<String, ConcurrentRTProfile>();
        for (Map.Entry<String, ConcurrentRTProfile> each : this.pureRTMap.entrySet()) {
            metaData.put(each.getKey(), each.getValue());
        }
        this.pureRTMap.clear();
        return metaData;
    }

    public void start() {
        if (this.configService.isRtCollect()) {
            RT_LOCAL.get().setStart(System.currentTimeMillis());
        }
    }

    public void stop(String serviceUniqueName, String remoteIp) {
        ConcurrentRTProfile old;
        if (!this.configService.isClientRtCollect()) {
            return;
        }
        RTLocal local = RT_LOCAL.get();
        long elapsed = System.currentTimeMillis() - local.getStart();
        if (elapsed <= 0L) {
            return;
        }
        ConcurrentRTProfile pureData = this.pureRTMap.get(serviceUniqueName);
        if (null == pureData && null != (old = this.pureRTMap.putIfAbsent(serviceUniqueName, pureData = new ConcurrentRTProfile()))) {
            pureData = old;
        }
        pureData.add(elapsed, 1);
        if (this.configService.isRtOn() && null != remoteIp) {
            local.add(serviceUniqueName, remoteIp, elapsed);
            if (local.getCount() < this.configService.getRtThreadThreshold()) {
                return;
            }
            this.rtLoop.execute(new RereshRtMapTask(serviceUniqueName, local.reset()));
        }
    }

    private void collect(String serviceUniqueName, HashMap<String, HashMap<String, ThreadlocalRTProfile>> threadLocalProfileMap) {
        for (Map.Entry<String, HashMap<String, ThreadlocalRTProfile>> each : threadLocalProfileMap.entrySet()) {
            AtomicInteger serviceThreshold;
            String k = each.getKey();
            HashMap<String, ThreadlocalRTProfile> v = each.getValue();
            HashMap<String, ConcurrentRTProfile> remoteIp2Profile = this.serviceRtMap.get(k);
            if (null == remoteIp2Profile) {
                remoteIp2Profile = this.safePut(this.serviceRtMap, k, new HashMap());
            }
            if (null == (serviceThreshold = this.serviceInvokeCountMap.get(serviceUniqueName))) {
                serviceThreshold = this.safePut(this.serviceInvokeCountMap, serviceUniqueName, new AtomicInteger(0));
            }
            this.add2Global(remoteIp2Profile, v, serviceThreshold);
            if (serviceThreshold.get() < this.configService.getRtGlobalThreshold()) {
                return;
            }
            this.refreshRtWeight(serviceThreshold, serviceUniqueName);
        }
    }

    private void add2Global(HashMap<String, ConcurrentRTProfile> global, HashMap<String, ThreadlocalRTProfile> local, AtomicInteger serviceThreshold) {
        for (Map.Entry<String, ThreadlocalRTProfile> each : local.entrySet()) {
            String k = each.getKey();
            ThreadlocalRTProfile v = each.getValue();
            serviceThreshold.addAndGet(v.getCount());
            ConcurrentRTProfile cRtProfile = global.get(k);
            if (null == cRtProfile) {
                cRtProfile = this.safePut(global, k, new ConcurrentRTProfile());
            }
            cRtProfile.add(v.getElapsedTime(), v.getCount());
        }
    }

    private void refreshRtWeight(AtomicInteger serviceThreshold, String serviceUniqueName) {
        int count = serviceThreshold.getAndSet(0);
        HashMap priviousMap = this.serviceRtMap.put(serviceUniqueName, new HashMap());
        long elapsedTime = 0L;
        for (ConcurrentRTProfile profile : priviousMap.values()) {
            elapsedTime += profile.getElapsedTime();
        }
        long average = elapsedTime / (long)count;
        HashMap<String, Integer> weightMap = new HashMap<String, Integer>();
        for (Map.Entry each : priviousMap.entrySet()) {
            String k = (String)each.getKey();
            ConcurrentRTProfile v = (ConcurrentRTProfile)each.getValue();
            long eachAverage = v.getElapsedTime() / (long)v.getCount();
            if (average <= eachAverage) continue;
            long tmpAverage = average;
            int weight = 1;
            while ((tmpAverage -= eachAverage) >= eachAverage && ++weight < 5) {
            }
            if (weight <= 1) continue;
            weightMap.put(k, weight);
        }
        if (weightMap.size() > 0) {
            this.addressService.setRtWeightMap(serviceUniqueName, weightMap);
            System.out.println("[RTCalculator] refresh RtWeightMap");
            System.out.println("[RTCalculator] serviceUniqueName:" + serviceUniqueName);
            System.out.println("[RTCalculator] weightMap:\n" + weightMap);
        }
    }

    private <K, V> V safePut(Map<K, V> map, K key, V v) {
        map.put(key, v);
        return v;
    }

    public static final class ConcurrentRTProfile
    implements RTProfile {
        final AtomicLong elapsedTimeAdder = new AtomicLong(0L);
        final AtomicInteger countAdder = new AtomicInteger(0);

        @Override
        public long getElapsedTime() {
            return this.elapsedTimeAdder.get();
        }

        @Override
        public int getCount() {
            return this.countAdder.get();
        }

        @Override
        public void add(long elapsedTime, int count) {
            long afterCountAdd;
            if (this.elapsedTimeAdder.get() == Long.MAX_VALUE || this.countAdder.get() == Integer.MAX_VALUE) {
                return;
            }
            long afterElapsedTimeAdd = this.elapsedTimeAdder.addAndGet(elapsedTime);
            if (afterElapsedTimeAdd < 0L) {
                this.elapsedTimeAdder.set(Long.MAX_VALUE);
            }
            if ((afterCountAdd = (long)this.countAdder.addAndGet(count)) < 0L) {
                this.countAdder.set(Integer.MAX_VALUE);
            }
        }
    }

    static final class ThreadlocalRTProfile
    implements RTProfile {
        long elapsedTimeAdder = 0L;
        int countAdder = 0;

        ThreadlocalRTProfile() {
        }

        @Override
        public long getElapsedTime() {
            return this.elapsedTimeAdder;
        }

        @Override
        public int getCount() {
            return this.countAdder;
        }

        @Override
        public void add(long elapsedTime, int count) {
            if (this.elapsedTimeAdder == Long.MAX_VALUE || this.countAdder == Integer.MAX_VALUE) {
                return;
            }
            long leftElapse = Long.MAX_VALUE - this.elapsedTimeAdder;
            this.elapsedTimeAdder = leftElapse >= elapsedTime ? (this.elapsedTimeAdder += elapsedTime) : Long.MAX_VALUE;
            int leftCount = Integer.MAX_VALUE - count;
            this.countAdder = leftCount >= count ? (this.countAdder += count) : Integer.MAX_VALUE;
        }
    }

    static interface RTProfile {
        public long getElapsedTime();

        public int getCount();

        public void add(long var1, int var3);
    }

    static final class RTLocal {
        private long start = System.currentTimeMillis();
        private int countAddr = 0;
        private HashMap<String, HashMap<String, ThreadlocalRTProfile>> localMap = new HashMap();

        RTLocal() {
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void add(String serviceUniqueName, String remoteIp, long elapsedTime) {
            ThreadlocalRTProfile profile;
            HashMap<String, ThreadlocalRTProfile> remoteIp2Profile = this.localMap.get(serviceUniqueName);
            if (null == remoteIp2Profile) {
                remoteIp2Profile = new HashMap();
                this.localMap.put(serviceUniqueName, remoteIp2Profile);
            }
            if (null == (profile = remoteIp2Profile.get(remoteIp))) {
                profile = new ThreadlocalRTProfile();
                remoteIp2Profile.put(remoteIp, profile);
            }
            profile.add(elapsedTime, 1);
            ++this.countAddr;
        }

        public int getCount() {
            return this.countAddr;
        }

        public HashMap<String, HashMap<String, ThreadlocalRTProfile>> reset() {
            this.countAddr = 0;
            HashMap<String, HashMap<String, ThreadlocalRTProfile>> ret = this.localMap;
            this.localMap = new HashMap();
            return ret;
        }
    }

    private final class RereshRtMapTask
    implements Runnable {
        final HashMap<String, HashMap<String, ThreadlocalRTProfile>> map;
        final String serviceUniqueName;

        private RereshRtMapTask(String serviceUniqueName, HashMap<String, HashMap<String, ThreadlocalRTProfile>> map) {
            this.map = map;
            this.serviceUniqueName = serviceUniqueName;
        }

        @Override
        public void run() {
            try {
                RTCalculator.this.collect(this.serviceUniqueName, this.map);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class InstanceHolder {
        private static final RTCalculator i = new RTCalculator();

        private InstanceHolder() {
        }
    }
}

