/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.server.output;

import com.taobao.hsf.CustomizedSerializerHelper;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.RpcRequest;
import com.taobao.hsf.remoting.RpcResponse;
import com.taobao.hsf.remoting.serialize.Codecs;
import com.taobao.hsf.remoting.serialize.Encoder;
import com.taobao.hsf.remoting.server.output.ServerOutput;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.text.MessageFormat;

public final class RpcOutput
extends ServerOutput {
    private final RpcRequest request;

    public RpcOutput(Connection connection, RpcRequest request, long startTime) {
        super(connection, startTime);
        this.request = request;
    }

    @Override
    public int writeHSFResponse(HSFResponse hsfResponse) {
        int responseSize = 0;
        if (hsfResponse.isError()) {
            byte[] reponseObject = hsfResponse.getErrorMsg().getBytes(RemotingConstants.DEFAULT_CHARSET);
            responseSize = reponseObject.length;
            this.connection.writeReponseToChannel(new RpcResponse(this.request.getRequestID(), this.request.getCodecType(), ResponseStatus.SERVICE_ERROR, reponseObject));
        } else {
            try {
                byte codecType = this.request.getCodecType();
                byte[] reponseObject = null;
                if (codecType != 7) {
                    Encoder encoder = Codecs.getEncoder(codecType);
                    reponseObject = encoder.encode(hsfResponse.getAppResponse());
                } else {
                    String methodKey = this.request.getMethodKey();
                    reponseObject = CustomizedSerializerHelper.getTransformer(methodKey).encodeResult(hsfResponse.getAppResponse());
                }
                responseSize = reponseObject.length;
                if (System.currentTimeMillis() - this.startTime >= (long)this.request.getTimeout()) {
                    StringBuilder errorMsgBuilder = new StringBuilder("##########");
                    errorMsgBuilder.append("give up send response to client:").append(this.request.getRequestID()).append('|').append(this.connection.getPeerIP()).append('|').append(System.currentTimeMillis() - this.startTime).append('|').append(this.request.getTimeout());
                    LoggerInit.LOGGER.warn(errorMsgBuilder.toString());
                } else {
                    this.connection.writeReponseToChannel(new RpcResponse(this.request.getRequestID(), this.request.getCodecType(), ResponseStatus.OK, reponseObject));
                }
            }
            catch (Exception e) {
                LoggerInit.LOGGER.error("", "[Provider Error]:" + this.connection, (Throwable)e);
                byte[] reponseObject = MessageFormat.format("[HSF-Provider-{0}] Error log: {1}", InetAddressUtil.getIP(), LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0033", (String)"Biz-Problem", (String)("Serilization error during serialize response:" + e.getMessage()))).getBytes(RemotingConstants.DEFAULT_CHARSET);
                responseSize = reponseObject.length;
                this.connection.writeReponseToChannel(new RpcResponse(this.request.getRequestID(), this.request.getCodecType(), ResponseStatus.SERVER_ERROR, reponseObject));
            }
        }
        return responseSize;
    }
}

