/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.service;

import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.metadata.service.MetadataService;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerMethodModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.invoke.component.SyncInvokeComponent;
import com.taobao.hsf.remoting.netty.client.NettyClientFactory;
import com.taobao.hsf.remoting.rt.RTCalculator;
import com.taobao.hsf.remoting.serialize.NamedCustomSerialization;
import com.taobao.hsf.remoting.service.InvokeService;
import com.taobao.hsf.remoting.service.ProviderServer;
import com.taobao.hsf.remoting.service.RPCProtocolService;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.ThreadLocalUtil;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.remoting.serialize.CustomSerialization;
import com.taobao.remoting.serialize.SerializationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class RemotingRPCProtocolComponent
implements RPCProtocolService {
    private final AtomicBoolean isProviderStarted = new AtomicBoolean(false);
    private final ProviderServer providerServer = HSFServiceContainer.getInstance(ProviderServer.class);
    private static final Map<String, InvokeService> invokeServices = new HashMap<String, InvokeService>();
    private final MetadataService metadataService = HSFServiceContainer.getInstance(MetadataService.class);
    private final InvokeService syncInvokeService = invokeServices.get("SYNC");
    private static Integer defaultHsfClientTimeout;

    @Override
    public Object invoke(HSFRequest request, ConsumerMethodModel methodModel, RemotingURL remotingURL) throws HSFException {
        String methodName = methodModel.getMethodName();
        int timeout = this.getReadTimeout(methodModel.getMethodName(request), methodModel, remotingURL);
        InvokeService invokeService = null;
        ServiceMetadata metadata = methodModel.getMetadata();
        request.setRequestProps("target_group", metadata.getGroup());
        String invokeType = ThreadLocalUtil.getInvokeType();
        if (invokeType == null) {
            if (metadata.isAsyncall(methodName)) {
                ServiceMetadata.AsyncallMethod aMethod = metadata.getAsyncallMethod(methodName);
                invokeType = aMethod.getType().toUpperCase();
                invokeService = invokeServices.get(invokeType);
            } else {
                invokeService = this.syncInvokeService;
            }
        } else {
            invokeService = invokeServices.get(invokeType);
            ThreadLocalUtil.clearInvokeTypeSet();
        }
        if (null == invokeService) {
            throw new HSFException("\u6ca1\u6709\u53ef\u7528\u7684\u8c03\u7528HSF\u670d\u52a1\u7684\u5b9e\u73b0\uff0c\u6240\u9700\u7684\u8c03\u7528HSF\u670d\u52a1\u7684\u65b9\u5f0f\u4e3a\uff1aTBRemoting\u7684" + invokeType + "\u65b9\u5f0f");
        }
        byte codecType = metadata.isTOP() ? (byte)3 : (metadata.isNDI() ? (byte)1 : (byte)remotingURL.getSerializeType());
        if (invokeService instanceof SyncInvokeComponent) {
            RTCalculator.getInstance().start();
        }
        Object resp = invokeService.invoke(request, metadata, remotingURL, codecType, timeout, methodName);
        if (invokeService instanceof SyncInvokeComponent) {
            RTCalculator.getInstance().stop(metadata.getUniqueName(), remotingURL.getHost());
        }
        return resp;
    }

    @Override
    public void registerProvider(ServiceMetadata metadata) throws HSFException {
        if (this.isProviderStarted.compareAndSet(false, true)) {
            try {
                this.providerServer.startHSFServer();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            for (ProviderServiceModel serviceModel : ApplicationModel.instance().allProvidedServices()) {
                                RemotingRPCProtocolComponent.this.metadataService.unregister(serviceModel.getMetadata());
                            }
                            Thread.sleep(HSFServiceContainer.getInstance(ConfigurationService.class).getshutdownHookWaitTime());
                            RemotingRPCProtocolComponent.this.providerServer.stopHSFServer();
                        }
                        catch (Exception e) {
                            LoggerInit.LOGGER.warn("Exception happens during stop server:", new Object[]{e});
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new HSFException(LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0016", (String)"Env-Problem", (String)"\u542f\u52a8HSF SERVER\u5931\u8d25."), e);
            }
        }
        int corePoolSize = metadata.getCorePoolSize();
        int maxPoolSize = metadata.getMaxPoolSize();
        if (corePoolSize > 0 && maxPoolSize > 0 && maxPoolSize >= corePoolSize) {
            this.providerServer.allocThreadPool(metadata.getUniqueName(), corePoolSize, maxPoolSize);
        }
        this.providerServer.addMetadata(metadata.getUniqueName(), metadata, metadata.getTarget());
    }

    @Override
    public boolean validTarget(String targetURL) {
        if (targetURL != null) {
            try {
                return NettyClientFactory.getInstance().get(RemotingURL.valueOf(targetURL)) != null;
            }
            catch (Exception e) {
                LoggerInit.LOGGER.debug("wrong validate URL:", new Object[]{e});
                return false;
            }
        }
        return false;
    }

    private int getReadTimeout(String methodName, ConsumerMethodModel methodModel, RemotingURL targetURL) {
        int timeout = methodModel.getTimeout();
        if (timeout > 0) {
            return timeout;
        }
        if (defaultHsfClientTimeout != null) {
            return defaultHsfClientTimeout;
        }
        List<MethodSpecial> serverCfg = targetURL.getMethodSpecials();
        for (MethodSpecial serverMethodSpecial : serverCfg) {
            if (!serverMethodSpecial.getMethodName().equals(methodName)) continue;
            return (int)serverMethodSpecial.getClientTimeout();
        }
        return targetURL.getTimeout();
    }

    static {
        for (InvokeService invokeService : HSFServiceContainer.getInstances(InvokeService.class)) {
            invokeServices.put(invokeService.getKey().toUpperCase(), invokeService);
        }
        for (NamedCustomSerialization serialization : HSFServiceContainer.getInstances(NamedCustomSerialization.class)) {
            SerializationUtil.addCustom((String)serialization.getName(), (CustomSerialization)serialization);
        }
        defaultHsfClientTimeout = Integer.getInteger("defaultHsfClientTimeout");
    }
}

