/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.util;

import com.taobao.hsf.CustomizedSerializerHelper;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.RpcRequest;
import com.taobao.hsf.remoting.TbRemotingRequest;
import com.taobao.hsf.remoting.serialize.Codecs;
import com.taobao.hsf.remoting.serialize.Encoder;
import com.taobao.hsf.util.ClassUtils;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemotingUtil {
    private static final char AND = '&';
    private static final String RPC_CONTEXT = "rc";

    public static TbRemotingRequest convert2TbRemotingRequest(HSFRequest appRequest, byte codecType, int timeOut) throws Exception {
        ConnectionRequest request = new ConnectionRequest((Object)appRequest);
        request.setSerializeProtocol(codecType);
        SliceOutputStream os = new SliceOutputStream();
        RemotingConstants.CONN_REQUEST_SERIALIZER.serialize(request, codecType, (OutputStream)os);
        return new TbRemotingRequest(os, request.getMessageId(), codecType, timeOut);
    }

    public static BaseRequest convert2RpcRequest(HSFRequest request, byte codecType, int timeout) throws Exception {
        Object argBytes;
        String targetInstanceName = request.getTargetServiceUniqueName();
        String methodName = request.getMethodName();
        String[] argTypes = request.getMethodArgSigs();
        Object[] args = request.getMethodArgs();
        Map<String, Object> requestProps = request.getRequestProps();
        byte[] requestPropsBytes = null;
        int requestSize = 0;
        if (codecType != 7) {
            argBytes = new byte[args.length][];
            Encoder encoder = Codecs.getEncoder(codecType);
            int i = 0;
            for (Object object : args) {
                argBytes[i] = encoder.encode(object);
                requestSize += argBytes[i++].length;
            }
            requestPropsBytes = encoder.encode(requestProps);
        } else {
            String methodKey = CustomizedSerializerHelper.catMethodName(targetInstanceName, methodName, argTypes);
            argBytes = CustomizedSerializerHelper.getTransformer(methodKey).encodeParameters(args);
            requestPropsBytes = Codecs.REQUESTPROP_ENCODER.encode(requestProps);
        }
        RpcRequest wrapper = new RpcRequest(timeout, targetInstanceName, methodName, argTypes, (byte[][])argBytes, requestPropsBytes, codecType, requestSize);
        return wrapper;
    }

    public static String[] getMethodParameter(Object[] parameters) {
        if (parameters.length == 0) {
            return new String[0];
        }
        String[] result = new String[parameters.length];
        int i = 0;
        for (Object c : parameters) {
            result[i++] = c.getClass().getName();
        }
        return result;
    }

    public static HSFRequest convert(RpcRequest request) throws Exception {
        HSFRequest hsfRequest = new HSFRequest();
        hsfRequest.setSerializeType(request.getCodecType());
        String[] argTypes = request.getArgTypes();
        hsfRequest.setMethodArgSigs(argTypes);
        hsfRequest.setMethodName(request.getMethodName());
        hsfRequest.setTargetServiceUniqueName(request.getTargetInstanceName());
        Object[] requestObjects = null;
        byte serializeType = request.getCodecType();
        byte[][] argsBytes = request.getRequestObjects();
        if (request.getCodecType() != 7) {
            requestObjects = new Object[argsBytes.length];
            for (int i = 0; i < argsBytes.length; ++i) {
                requestObjects[i] = Codecs.getDecoder(serializeType).decode(argsBytes[i], ClassUtils.forName(argTypes[i]));
            }
        } else {
            String methodKey = hsfRequest.getMethodKey();
            requestObjects = CustomizedSerializerHelper.getTransformer(methodKey).decodeParameters(argsBytes);
        }
        hsfRequest.setMethodArgs(requestObjects);
        Map properties = null;
        byte[] requestProp = request.getRequestProps();
        properties = serializeType != 7 ? (Map)Codecs.getDecoder(serializeType).decode(requestProp, Map.class) : (Map)Codecs.REQUESTPROP_DECODER.decode(requestProp, Map.class);
        hsfRequest.refreshRequestProp(properties);
        return hsfRequest;
    }

    public static List<MethodSpecial> getMethodSpecials(String target) {
        ArrayList<MethodSpecial> specials = new ArrayList<MethodSpecial>();
        if (target.contains("#")) {
            for (String str : target.split("&")) {
                MethodSpecial special = MethodSpecial.parseMethodSpecial(str);
                if (null == special) continue;
                specials.add(special);
            }
        }
        return specials;
    }
}

