/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.route.component;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.route.component.RouteResultCache;
import com.taobao.hsf.route.service.Args2KeyCalculator;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class RouteResultCacheImpl
implements RouteResultCache {
    private static final Logger LOGGER_CONFIG = LoggerInit.LOGGER_CONFIG;
    private final String serviceUniqueName;
    private volatile List<String> newAllAvailableAddresses = new ArrayList<String>();
    private volatile RouteRule newRoutingRule;
    private volatile RefHolder refs = new RefHolder(new ArrayList<String>(), new RouteRule(), new HashMap<Object, List<String>>(), new ArrayList<String>(), new HashMap<String, List<String>>(), new HashMap<String, Map<Object, List<String>>>());

    private static String doRegularExpressionReplace(String pattern) {
        if (pattern == null) {
            return pattern;
        }
        pattern = pattern.replaceAll("\\.", "\\\\.");
        pattern = pattern.replaceAll("\\*", "\\.\\*");
        pattern = pattern.replaceAll("\\?", "\\.{1}");
        return pattern;
    }

    private static List<String> filter(List<String> addresses, List<String> rule, boolean isIpRegexOn) {
        if (addresses == null) {
            return new ArrayList<String>();
        }
        if (isIpRegexOn) {
            return RouteResultCacheImpl.filterWithRegex(addresses, rule);
        }
        return RouteResultCacheImpl.filterWithoutRegex(addresses, rule);
    }

    private static List<String> filterWithRegex(List<String> addresses, List<String> regxList) {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        for (String regx : regxList) {
            patterns.add(Pattern.compile(RouteResultCacheImpl.doRegularExpressionReplace(regx)));
        }
        ArrayList<String> result = new ArrayList<String>();
        block1: for (String address : addresses) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(address).matches()) continue;
                result.add(address);
                continue block1;
            }
        }
        return result;
    }

    private static List<String> filterWithoutRegex(List<String> addresses, List<String> ipRule) {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> prefixes = new HashSet<String>(ipRule.size(), 1.0f);
        for (String rule : ipRule) {
            if (rule.equals("*")) {
                result.addAll(addresses);
                return result;
            }
            int index = rule.indexOf(":");
            if (index > -1) {
                prefixes.add(rule.substring(0, index));
                continue;
            }
            index = rule.indexOf("*");
            if (index > -1) {
                prefixes.add(rule.substring(0, index));
                continue;
            }
            prefixes.add(rule);
        }
        Iterator<String> iterator = addresses.iterator();
        while (iterator.hasNext()) {
            String address;
            String ip = address = iterator.next();
            int index = address.indexOf(":");
            if (index > -1) {
                ip = address.substring(0, index);
            }
            if (!prefixes.contains(ip)) continue;
            result.add(address);
        }
        return result;
    }

    private static <T> void intersection(Collection<T> c1, Collection<T> c2, Collection<T> result) {
        for (T e : c1) {
            if (!c2.contains(e)) continue;
            result.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> V putIfAbsent(Map<K, V> m, K key, V value) {
        Map<K, V> map = m;
        synchronized (map) {
            V exist = m.get(key);
            if (exist == null) {
                m.put(key, value);
                return value;
            }
            return exist;
        }
    }

    public RouteResultCacheImpl(String serviceUniqueName) {
        this.serviceUniqueName = serviceUniqueName;
    }

    public RouteResultCacheImpl(String unitName, String serviceUniqueName) {
        this.serviceUniqueName = serviceUniqueName;
    }

    @Override
    public List<String> getArgsAddresses(String methodName, String[] parameterTypes, Object[] args) {
        return this.getArgsAddressesWithoutLock(methodName, parameterTypes, args);
    }

    @Override
    public List<String> getInterfaceAddresses() {
        return this.getInterfaceAddressesWithoutLock();
    }

    @Override
    public void reset() {
        this.resetWithoutLock();
    }

    @Override
    public void setAllAvailableAddresses(List<String> allAvailableAddresses) {
        this.newAllAvailableAddresses = allAvailableAddresses;
    }

    @Override
    public void setRouteRule(RouteRule rule) {
        this.newRoutingRule = rule;
    }

    private List<String> getArgsAddressesWithoutLock(String methodName, String[] parameterTypes, Object[] args) {
        List<String> res;
        if (this.refs.routingRule.getArgsRule() == null) {
            return this.getMathodAddressesWithoutLock(methodName, parameterTypes);
        }
        Args2KeyCalculator c = this.refs.routingRule.getArgsRule().get(RouteRule.joinMethodSigs(methodName, parameterTypes));
        if (c == null) {
            return this.getMathodAddressesWithoutLock(methodName, parameterTypes);
        }
        Object key = c.calculate(args);
        if (key == null) {
            return this.getMathodAddressesWithoutLock(methodName, parameterTypes);
        }
        List addrs4Calculatedkey = (List)this.refs.allKeyedAddresses.get(key);
        if (addrs4Calculatedkey == null) {
            return this.getMathodAddressesWithoutLock(methodName, parameterTypes);
        }
        Map keyedAddresses = (HashMap)this.refs.methodKeyedAddresses.get(methodName);
        if (keyedAddresses == null) {
            keyedAddresses = new HashMap();
            keyedAddresses = RouteResultCacheImpl.putIfAbsent(this.refs.methodKeyedAddresses, methodName, keyedAddresses);
        }
        if ((res = (ArrayList<String>)keyedAddresses.get(key)) == null) {
            res = new ArrayList<String>();
            RouteResultCacheImpl.intersection(addrs4Calculatedkey, this.getMathodAddressesWithoutLock(methodName, parameterTypes), res);
            if (this.refs.routingRule.isEmptyProtection() && res.isEmpty()) {
                res.addAll(this.getMathodAddressesWithoutLock(methodName, parameterTypes));
            }
            res = RouteResultCacheImpl.putIfAbsent(keyedAddresses, key, res);
        }
        return res;
    }

    private List<String> getInterfaceAddressesWithoutLock() {
        return this.refs.interfaceAddresses == null ? this.refs.allAvailableAddresses : this.refs.interfaceAddresses;
    }

    private List<String> getMathodAddressesWithoutLock(String methodName, String[] paramTypeStrs) {
        List res = null;
        if (this.refs.methodAddresses != null && !this.refs.methodAddresses.isEmpty()) {
            res = (List)this.refs.methodAddresses.get(RouteRule.joinMethodSigs(methodName, paramTypeStrs));
        }
        return res == null ? this.getInterfaceAddressesWithoutLock() : res;
    }

    private void resetWithoutLock() {
        RefHolder newRefs;
        Map<String, Object> methodRule;
        List<String> rule;
        HashMap<Object, List<String>> _allKeyedAddresses = new HashMap<Object, List<String>>();
        List<String> _interfaceAddresses = null;
        HashMap<String, List<String>> _mathodAddresses = new HashMap<String, List<String>>();
        HashMap<String, Map<Object, List<String>>> _mathodKeyedAddresses = new HashMap<String, Map<Object, List<String>>>();
        if (this.newRoutingRule == null || this.newRoutingRule.getKeyedRules() == null) {
            this.newRoutingRule = new RouteRule();
        } else {
            LOGGER_CONFIG.warn("[Address Component] isEmptyProtection: " + this.newRoutingRule.isEmptyProtection());
            for (Map.Entry<? extends Object, ? extends List<String>> e : this.newRoutingRule.getKeyedRules().entrySet()) {
                if (e.getValue() == null) {
                    LOGGER_CONFIG.warn("[Address Component] null route rule for key[" + e.getKey() + "]");
                    _allKeyedAddresses.put(e.getKey(), new ArrayList<String>(this.newAllAvailableAddresses));
                    continue;
                }
                _allKeyedAddresses.put(e.getKey(), RouteResultCacheImpl.filter(this.newAllAvailableAddresses, e.getValue(), this.newRoutingRule.isIpRegexOn()));
            }
        }
        Object key4InterfaceRule = this.newRoutingRule.getInterfaceRule();
        if (key4InterfaceRule != null && (rule = this.newRoutingRule.getKeyedRules().get(key4InterfaceRule)) != null) {
            _interfaceAddresses = RouteResultCacheImpl.filter(this.newAllAvailableAddresses, rule, this.newRoutingRule.isIpRegexOn());
            if (this.newAllAvailableAddresses == null || this.newAllAvailableAddresses.isEmpty()) {
                LOGGER_CONFIG.warn("[Address Component] newAllAvailableAddresses is emtpy for service : " + this.serviceUniqueName);
            } else {
                boolean emptyProtectTriggered = false;
                if ((_interfaceAddresses == null || _interfaceAddresses.isEmpty()) && this.newRoutingRule.isEmptyProtection()) {
                    _interfaceAddresses = this.newAllAvailableAddresses;
                    emptyProtectTriggered = true;
                }
                LOGGER_CONFIG.info(MessageFormat.format("[Address Component] route result {0}, addresses remain[{1}], EmptyProtection triggered [{2}]", this.serviceUniqueName, _interfaceAddresses == null ? 0 : _interfaceAddresses.size(), emptyProtectTriggered));
            }
        }
        if ((methodRule = this.newRoutingRule.getMethodRule()) != null) {
            for (Map.Entry<String, Object> e : methodRule.entrySet()) {
                List<String> parentList = _interfaceAddresses == null ? this.newAllAvailableAddresses : _interfaceAddresses;
                List<String> regxList = this.newRoutingRule.getKeyedRules().get(e.getValue());
                if (regxList != null) {
                    List<String> _mathodAddressList = RouteResultCacheImpl.filter(parentList, regxList, this.newRoutingRule.isIpRegexOn());
                    boolean emptyProtectTriggered = false;
                    if ((_mathodAddressList == null || _mathodAddressList.isEmpty()) && !parentList.isEmpty() && this.newRoutingRule.isEmptyProtection()) {
                        _mathodAddressList = parentList;
                        emptyProtectTriggered = true;
                    }
                    _mathodAddresses.put(e.getKey(), _mathodAddressList);
                    LOGGER_CONFIG.warn(MessageFormat.format("[Address Component] route result  {0}_{1}, addresses remain[{2}], EmptyProtection triggered [{3}]", this.serviceUniqueName, e.getKey(), _mathodAddressList == null ? 0 : _mathodAddressList.size(), emptyProtectTriggered));
                    continue;
                }
                LOGGER_CONFIG.warn(MessageFormat.format("[Address Component] {0}_{1} generate invalid key [{2}], no corresponding value in routingRuleMap", this.serviceUniqueName, e.getKey(), e.getValue()));
            }
        }
        this.refs = newRefs = new RefHolder(this.newAllAvailableAddresses, this.newRoutingRule, _allKeyedAddresses, _interfaceAddresses, _mathodAddresses, _mathodKeyedAddresses);
    }

    private static class RefHolder {
        private final List<String> allAvailableAddresses;
        private final RouteRule routingRule;
        private final Map<Object, List<String>> allKeyedAddresses;
        private final List<String> interfaceAddresses;
        private final Map<String, List<String>> methodAddresses;
        private final Map<String, Map<Object, List<String>>> methodKeyedAddresses;

        public RefHolder(List<String> allAvailableAddresses, RouteRule routingRule, Map<Object, List<String>> allKeyedAddresses, List<String> interfaceAddresses, Map<String, List<String>> methodAddresses, Map<String, Map<Object, List<String>>> methodKeyedAddresses) {
            this.allAvailableAddresses = allAvailableAddresses;
            this.routingRule = routingRule;
            this.allKeyedAddresses = allKeyedAddresses;
            this.interfaceAddresses = interfaceAddresses;
            this.methodAddresses = methodAddresses;
            this.methodKeyedAddresses = methodKeyedAddresses;
        }
    }
}

