/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.route.flowcontrol;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.route.flowcontrol.FlowControlRule;
import com.taobao.hsf.route.flowcontrol.FlowControlRuleParseException;
import com.taobao.hsf.rule.AbstractRuleParser;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.hsf.util.StringMatcher;
import com.taobao.middleware.logger.Logger;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowControlRuleParser
extends AbstractRuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;

    @Override
    public String getRuleName() {
        return "flowControl";
    }

    @Override
    public FlowControlRule parse(String rawRule) throws FlowControlRuleParseException {
        if (rawRule == null || this.documentBuilder == null) {
            return null;
        }
        try {
            int beginIndex = rawRule.indexOf(64);
            String rule = rawRule.substring(beginIndex + 1);
            if (!rule.contains("<")) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(rule.getBytes());
            Document doc = this.documentBuilder.parse(is);
            FlowControlRule flowControlRule = new FlowControlRule();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                if ("localPreferredSwitch".equals(node.getNodeName())) {
                    String localPreferredSwitch = node.getTextContent().trim();
                    if (!"on".equals(localPreferredSwitch) && !"off".equals(localPreferredSwitch)) {
                        LOGGER.warn("[FlowControl Parser] Invalid isLocalPreferred valie! set 'off' as default.");
                        flowControlRule.setLocalPreferredSwitch("off");
                        continue;
                    }
                    flowControlRule.setLocalPreferredSwitch(localPreferredSwitch);
                    continue;
                }
                if ("threshold".equals(node.getNodeName())) {
                    String threshold = node.getTextContent().trim();
                    if (threshold == null || threshold.length() == 0) {
                        LOGGER.warn("[FlowControl Parser] Invalid threshold value! set 0.0F as default.");
                        continue;
                    }
                    float value = Float.valueOf(threshold).floatValue();
                    flowControlRule.setThreshold(value);
                    continue;
                }
                if ("exclusions".equals(node.getNodeName())) {
                    String exclusions = node.getTextContent().trim();
                    if (exclusions == null || exclusions.length() == 0) continue;
                    String[] exclusionIPs = exclusions.split(",");
                    String ip = InetAddressUtil.getIP();
                    if (ip == null) continue;
                    for (String exclusion : exclusionIPs) {
                        StringMatcher matcher = new StringMatcher(exclusion, true, false);
                        if (!matcher.match(ip)) continue;
                        LOGGER.warn(MessageFormat.format("[FlowControl Parser] Current host [{0}] is excluded for this rule.", ip));
                        return null;
                    }
                    continue;
                }
                LOGGER.warn("[FlowControl Parser] Unsupported node: " + node);
            }
            return flowControlRule;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[FlowControl Parser] Threshold must be a number value.", new Object[]{e});
            return null;
        }
        catch (Exception e) {
            throw new FlowControlRuleParseException("FlowControlRule", "FlowControl Rule parsed failed!", e);
        }
    }
}

