/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.rule;

import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.rule.Rule;
import com.taobao.hsf.rule.RuleParseException;
import com.taobao.hsf.rule.RuleParser;
import com.taobao.middleware.logger.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public abstract class AbstractRuleParser
implements RuleParser {
    private static final Logger LOGGER = LoggerInit.LOGGER;
    protected DocumentBuilder documentBuilder = null;

    public AbstractRuleParser() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("", "error create document builder!", (Throwable)e);
        }
    }

    @Override
    public boolean accept(String rawRule) {
        if (rawRule == null || rawRule.trim().length() == 0) {
            return false;
        }
        int end = this.getRuleName().length() + 1;
        String header = rawRule.trim().substring(0, end);
        return (this.getRuleName() + "@").equals(header);
    }

    @Override
    public abstract String getRuleName();

    @Override
    public abstract Rule parse(String var1) throws RuleParseException;
}

