/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tbremoting.invoke;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFTimeOutException;
import com.taobao.middleware.logger.support.LoggerHelper;
import com.taobao.remoting.ResponseFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HSFFuture {
    private final Future<Object> future;

    public HSFFuture(Future<Object> future) {
        this.future = future;
    }

    public Object getResponse(long timeout) throws HSFException, InterruptedException, Throwable {
        try {
            Object rawResponse = this.future.get(timeout, TimeUnit.MILLISECONDS);
            if (ResponseFuture.ASYN_NOT_DONE == rawResponse) {
                throw new HSFException("\u6307\u5b9a\u7684timeout[" + timeout + "ms]\u65f6\u95f4\u5df2\u5230\uff0c\u4f46\u7ed3\u679c\u8fd8\u6ca1\u8fd4\u56de");
            }
            HSFResponse hsfResp = (HSFResponse)rawResponse;
            if (hsfResp.isError()) {
                throw new HSFException(hsfResp.getErrorMsg(), hsfResp.getErrorMsg());
            }
            Object appResponse = hsfResp.getAppResponse();
            if (appResponse instanceof Throwable) {
                throw (Throwable)appResponse;
            }
            return appResponse;
        }
        catch (ExecutionException e) {
            throw new HSFTimeOutException(this.getErrorLog(), e);
        }
        catch (TimeoutException e) {
            throw new HSFTimeOutException(this.getErrorLog(), e);
        }
    }

    private String getErrorLog() {
        return LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0002", (String)"Biz-Problem", (String)"");
    }
}

