/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model.threshold;

import com.taobao.hsf.tps.model.TokenBucketLimiter;
import com.taobao.hsf.tps.service.Limiter;

public abstract class BaseLevel {
    public static final int DEFAULT_TIMEWINDOW = 1;
    protected String name;
    protected Limiter limiter;

    public BaseLevel(String name, int rate, int peak, int timeWindow) {
        if (timeWindow <= 0) {
            timeWindow = 1;
        }
        if (peak <= 0) {
            peak = rate * timeWindow;
        }
        this.name = name;
        this.limiter = new TokenBucketLimiter(rate, peak, timeWindow);
    }

    public boolean check() {
        if (this.limiter == null) {
            throw new NullPointerException("TokenBucketLimiter need to be initialized before used.");
        }
        return this.limiter.check();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "BaseLevel [name=" + this.name + ", limiter=" + this.limiter + "]";
    }

    public boolean validate() {
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        return this.limiter.validate();
    }
}

