/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model.threshold;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.tps.model.threshold.BaseLevel;
import com.taobao.hsf.tps.model.threshold.ConsumerLevel;
import java.util.HashMap;
import java.util.Map;

public class MethodLevel
extends BaseLevel {
    private Map<String, ConsumerLevel> consumers;

    public MethodLevel(String name, int rate, int peak, int timeWindow) {
        super(name, rate, peak, timeWindow);
    }

    public void addConsumerLevel(ConsumerLevel cl) {
        this.getConsumers().put(cl.getName(), cl);
    }

    public Map<String, ConsumerLevel> getConsumers() {
        if (this.consumers == null) {
            this.consumers = new HashMap<String, ConsumerLevel>();
        }
        return this.consumers;
    }

    public boolean matches(HSFRequest request) {
        if (this.getConsumers() != null && !this.getConsumers().isEmpty()) {
            ConsumerLevel cl;
            String consumer = null;
            if (request.getRequestProp("Consumer-AppName") != null) {
                consumer = (String)request.getRequestProp("Consumer-AppName");
            }
            if (consumer == null) {
                return this.check();
            }
            if (this.getConsumers().containsKey(consumer) && (cl = this.getConsumers().get(consumer)) != null) {
                return cl.check();
            }
        }
        return this.check();
    }

    @Override
    public String toString() {
        return "MethodLevel [name=" + this.name + ", limiter=" + this.limiter + ", consumers=" + this.consumers + "]";
    }

    @Override
    public boolean validate() {
        for (ConsumerLevel cl : this.getConsumers().values()) {
            if (cl.validate()) continue;
            return false;
        }
        return super.validate();
    }
}

