/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tps.model.threshold;

import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.tps.model.threshold.ServiceLevel;
import com.taobao.hsf.tps.service.TPSRule;
import java.util.HashMap;
import java.util.Map;

public class Threshold
extends TPSRule {
    private Map<String, ServiceLevel> services;

    public void addServiceLevel(ServiceLevel serviceLevel) {
        this.getServices().put(serviceLevel.getName(), serviceLevel);
    }

    @Override
    public String getName() {
        return "Threshold";
    }

    public Map<String, ServiceLevel> getServices() {
        if (this.services == null) {
            this.services = new HashMap<String, ServiceLevel>();
        }
        return this.services;
    }

    @Override
    public boolean matches(Object data, HSFRequest request) {
        ServiceLevel sl;
        String serviceUniqueName = request.getTargetServiceUniqueName();
        if (this.getServices().containsKey(serviceUniqueName) && (sl = this.getServices().get(serviceUniqueName)) != null) {
            return sl.matches(request);
        }
        return true;
    }

    public String toString() {
        return "Threshold [services=" + this.services + "]";
    }

    @Override
    public boolean validate() {
        for (ServiceLevel sl : this.getServices().values()) {
            if (sl.validate()) continue;
            return false;
        }
        return true;
    }
}

